var Configurator;
var Entry;

var assert = require('assert');

/**
 * Writes the message
 */
module.exports = require('inherit')({
    /**
     * @param {Configurator} configuration
     * @constructor
     * @class AbstractHandler
     */
    __constructor: function(configuration) {
        Configurator = Configurator || require('../Configurator');
        assert(configuration instanceof Configurator, 'Configuration should be an instance of Configurator');
        this._config = configuration;
    },

    _handle: function() {
        throw new Error('Should be overwritten by a successor');
    },

    /**
     * Handle the log entry
     * @param {LogEntry} entry    An entry string
     */
    handle: function(entry) {
        Entry = Entry || require('../Entry');
        assert(entry instanceof Entry, 'Entry should be a LogEntry');

        var level = entry.getLevel();

        if (this._config.levelImportantEnough(level)) {
            if (this._config.logIdRquiredForLevel(level)) {
                var logId = entry.getLogId();

                assert(
                    logId && logId !== 'unknown',
                    'Log ID should be specified for log level %s'.replace('%s', level)
                );
            }

            this._handle.apply(this, arguments);
        }
    }
});
