var Buff = require('inherit')({
    __constructor: function() {
        this._buf = [];
    },

    write: function(str) {
        this._buf.push(str);
        return this;
    },

    flush: function() {
        var data = this._buf.join('\n');

        this._buf = [];
        return data ? data + '\n' : '';
    },

    isEmpty: function() {
        return this._buf.length === 0;
    }
});

module.exports = require('inherit')(
    require('./AbstractHandler'),
    {
        __constructor: function() {
            this.__base.apply(this, arguments);

            this._buf = this.__self.getBuffer();
            this._stream = this.__self.getStream();

            var that = this;

            setInterval(function() {
                if (!that._buf.isEmpty()) {
                    that._flush();
                }
            }, 1000);
        },

        _flush: function() {
            this._stream.write(this._buf.flush());
        },

        _handle: function(entry) {
            this._buf.write(entry.getFormatted());
        }
    },
    {
        Buffer: Buff,
        getBuffer: function() {
            return new Buff();
        },
        getStream: function() {
            return process.stdout;
        }
    }
);
