const {resolve} = require('path');
const pixrem = require('pixrem');
const postcssThemFold = require('postcss-theme-fold');
const postcssColorFunction = require('postcss-color-function');
const postcssSimpleVars = require('postcss-simple-vars');

const postcssThemFoldOptions = {
    mode: 'multi-themes',
    themes: [
        [resolve(__dirname, 'pcomponents/Theme/theme.css')],
        [resolve(__dirname, 'pcomponents/Theme/darkTheme/css/theme_dark.css')]
    ],
    globalSelectors: ['.utilityfocus']
};
const plugins = [
    pixrem({rootValue: 10}),
    postcssSimpleVars,
    postcssColorFunction,
    postcssThemFold(postcssThemFoldOptions)
];

module.exports = {
    plugins
};
