'use strict';

const util = require('util');
const _ = require('lodash');
const fs = require('fs');
const FormData = require('form-data');

const isXML = new RegExp(/^<\?xml/);
const mask = '***';
const blackList = [
    'access_token',
    'answer',
    'app_secret',
    'attach',
    'billing_response',
    'client_secret',
    'code',
    'cookies',
    'current_password',
    'events',
    'hashes',
    'hint_answer',
    'hint_question',
    'history_answer',
    'history_question',
    'key',
    'log',
    'oauth_token',
    'otp',
    'passwd',
    'passwd2',
    'password',
    'password_confirm',
    'password-confirm',
    'passwords',
    'pin',
    'secret',
    'secret_key',
    'secret_link',
    'session',
    'session_id',
    'sessionid',
    'signed_value',
    'sslsession',
    'sslsessionid',
    'token',
    'totp_app_secret',
    'totp_pin',
    'totp_secret',
    'totp_url',
    'x_token',
    'x_token_client_secret',
    'secure_phone_number',
    'number',
    'phone_number',
    'service_guard_container',
    'sessguard'
];
const blackListLength = blackList.length;

exports.clearLog = (fields) => {
    const post = JSON.parse(JSON.stringify(fields || {}));

    if (post.body && isXML.test(post.body)) {
        post.body = mask;
    }

    for (let i = 0; i < blackListLength; i++) {
        const field = blackList[i];

        if (typeof post[field] !== 'undefined' && post[field] !== '') {
            post[field] = mask;
        }
    }

    return post;
};

exports.localdate = () => {
    const d = new Date();
    const ms = d.getMilliseconds();
    const s = d.toString().split(' ');
    const month = `00${d.getMonth() + 1}`.slice(-2);

    return util.format('%s-%s-%s %s.%s', s[3], month, s[2], s[4], ms); // 2015-11-19 03:59:50.123
};

exports.grdate = () => {
    const d = new Date();
    const s = d.toString().split(' ');

    return {
        unixtime: (d.getTime() / 1000).toFixed(),
        timestamp: util.format('%s/%s/%s:%s', s[2], s[1], d.getFullYear(), s[4])
    };
};

exports.toTSKV = (obj) => _.map(obj, (val, key) => `${key}=${val}`).join('\t');

exports.getFormData = (data = {}) => {
    const form = new FormData();

    Object.keys(data).forEach((key) => {
        if (typeof data[key] !== 'undefined') {
            if (typeof data[key] === 'object' && data[key] && data[key].path) {
                form.append(key, fs.createReadStream(data[key].path));
            } else {
                form.append(key, data[key]);
            }
        }
    });

    return form;
};

exports.getFormDataHeaders = (form) => {
    const headers = form.getHeaders();

    return {
        ...headers,
        'ya-client-content-type': headers['content-type']
    };
};

exports.isInstanceOfFormData = (data) => data instanceof FormData;
