const assert = require('assert');
const inherit = require('inherit');

/**
 * @type {RecursiveRouter}
 * @constructor
 */
var RecursiveRouter = inherit(
    {
        /**
         * @param {string}  url
         * @param {string}  [method]
         * @returns Match
         * @private
         *
         * @throws
         */
        _match: function() {
            throw new Error('Should be implemented');
        },

        _matchPage: function() {
            throw new Error('Should be implemented');
        },

        /**
         * Transform the url when calling a next level of RecursiveRouter
         * @param {string} originalUrl
         * @param {string} matchedUrl
         * @returns {string}
         * @private
         */
        transformUrl: function(originalUrl) {
            return originalUrl;
        },

        /**
         * @param {string} url
         * @param {string} [method]
         * @returns {*}
         */
        match: function(url, method) {
            assert(typeof url === 'string', 'Url should be a string');
            assert(!method || typeof method === 'string', 'Method is optional, but should be a string if provided');

            var matched = this._match(url, method);

            if (matched) {
                var result = matched.getResult();

                if (result instanceof RecursiveRouter) {
                    return result.match(this.transformUrl(url, matched.getMatchedPath()), method);
                }

                return result;
            }

            throw new URIError('Router had no match');
        },

        matchPage: function(url, method) {
            assert(typeof url === 'string', 'Url should be a string');
            assert(!method || typeof method === 'string', 'Method is optional, but should be a string if provided');

            var matched = this._matchPage(url, method);

            if (matched instanceof RecursiveRouter) {
                return matched.match(this.transformUrl(url), method);
            }

            return matched;
        }
    },
    {
        Match: inherit({
            __constructor: function(result, matchedPath) {
                this._result = result;
                this._matchedPath = matchedPath;
            },

            getResult: function() {
                return this._result;
            },

            getMatchedPath: function() {
                return this._matchedPath;
            }
        })
    }
);

module.exports = RecursiveRouter;
