const assert = require('assert');
const inherit = require('inherit');
const Mapping = require('./Mapping');

/**
 * A router for the registration that checks mapped values
 *
 * @extends {prouter/Mapping}
 * @typedef {TypedMappingRouter}
 */
var TypedMappingRouter = inherit(Mapping, {
    /**
     * @param {function} type                       Type constructor to check the values belong to
     * @constructor {TypedMappingRouter}
     */
    __constructor: function(type) {
        this.__base.apply(this, arguments);

        assert(typeof type === 'function', 'Type should be a constructor');
        this._type = type;
    },

    getType: function() {
        return this._type;
    },

    _checkType: function(value, message) {
        if (typeof value === 'object') {
            assert(value instanceof this.getType(), message);
        } else {
            assert(value.prototype instanceof this.getType(), message);
        }
    },

    map: function(key, value) {
        var validationMessage = 'Routing result is a given type successor or TypedMappingRouter with the same type';

        if (value instanceof TypedMappingRouter) {
            assert(value.getType() === this.getType(), validationMessage);
        } else {
            this._checkType(value, validationMessage);
        }

        return this.__base.apply(this, arguments);
    },

    default: function(value) {
        this._checkType(value, 'Default route should be a given type successor or a type instance');
        return this.__base.apply(this, arguments);
    }
});

module.exports = TypedMappingRouter;
