var csrfSalt = null;
var v2 = require('secret-key/v2');
var assert = require('assert');

var csrf = function(uid, yandexuid) {
    assert(csrfSalt !== null, 'Salt should be defined with csrf.setSalt()');

    uid = uid || '0';
    yandexuid = yandexuid || '0';

    /*jshint bitwise: false*/
    var days = (new Date() / 86400000) << 0;

    var md5 = require('crypto').createHash('md5');

    return md5.update(csrfSalt + ':' + uid + ':' + yandexuid + ':' + days).digest('hex');
};

var csrfV2 = function(uid, yandexuid) {
    assert(csrfSalt !== null, 'Salt should be defined with csrf.setSalt()');

    return v2({salt: csrfSalt, uid: uid, yandexuid: yandexuid});
};

csrfV2.isValid = function(uid, yandexuid, token) {
    assert(csrfSalt !== null, 'Salt should be defined with csrf.setSalt()');

    return v2.isValid(token, {
        salt: csrfSalt,
        uid: uid,
        yandexuid: yandexuid
    });
};

csrf.setSalt = function(salt) {
    assert(salt && typeof salt === 'string', 'Salt should be a string');
    csrfSalt = salt;
    return csrf;
};

csrfV2.setSalt = csrf.setSalt;

module.exports = csrfV2;
