module.exports = function merge() {
    var target = arguments[0];
    var stack = [];

    for (var index = 0; index < arguments.length; index++) {
        if (
            Object.hasOwnProperty.call(arguments, index) &&
            (typeof arguments[index] != 'object' || Array.isArray(arguments[index]))
        ) {
            throw new Error('Every argument should be with type "object"');
        } else if (index > 0) {
            stack.push({target, source: arguments[index]});
        }
    }

    if (arguments.length < 2) {
        return arguments[0];
    }

    while (stack.length) {
        var task = stack.pop();
        var currentObj = task.source;
        var targetValue = task.target;

        for (const prop in currentObj) {
            if (Object.hasOwnProperty.call(currentObj, prop) && currentObj[prop] !== undefined) {
                // if both plainObject
                if (
                    targetValue[prop] &&
                    typeof targetValue[prop] === 'object' &&
                    !Array.isArray(targetValue[prop]) &&
                    currentObj[prop] &&
                    typeof currentObj[prop] === 'object' &&
                    !Array.isArray(currentObj[prop])
                ) {
                    stack.push({target: targetValue[prop], source: currentObj[prop]});
                } else {
                    targetValue[prop] = currentObj[prop];
                }
            }
        }
    }

    return target;
};
