var util = require('util');
var i18n = require('./libs/i18n');
var csrf = require('./libs/csrf');
var cloneDeep = require('./libs/cloneDeep');
var merge = require('./libs/merge');
var simpleCipher = require('./libs/xor_cipher');

var putils = {
    i18n: i18n,
    csrf: csrf,
    cloneDeep: cloneDeep,
    merge: merge,
    formatDate: function(year, month, day) {
        return util.format('%s-%s-%s', year || '0000', month || '00', day < 10 ? '0' + day : day || '00');
    },
    flattenObject: function(obj) {
        var toReturn = {};

        for (var i in obj) {
            if (!obj.hasOwnProperty(i)) {
                continue;
            }
            if (typeof obj[i] === 'object' && obj[i] !== null && !Array.isArray(obj[i])) {
                var flatObject = putils.flattenObject(obj[i]);

                for (var x in flatObject) {
                    if (!flatObject.hasOwnProperty(x)) {
                        continue;
                    }
                    toReturn[i + '.' + x] = flatObject[x];
                }
            } else {
                toReturn[i] = obj[i];
            }
        }
        return toReturn;
    },
    simpleCipher: simpleCipher
};

module.exports = putils;
