var _ = require('lodash');
var when = require('when');
var assert = require('assert');

var View = require('./View');

/**
 * A view capable of compiling multiple views into a single hash fot templating
 *
 * @typedef CompositeView
 * @class CompositeView
 * @extends View
 * @constructor
 */
module.exports = require('inherit')(View, {
    /**
     * @class CompositeView
     * @constructor
     */
    __constructor: function() {
        this.__base.apply(this, arguments);
        this._subviews = [];
    },

    /**
     * Append a subview to the view
     * @param {View}        view
     * @returns {exports}
     */
    append: function(view) {
        assert(view instanceof View, 'Appended subview should be an instance of View');
        this._subviews.push(view);
        this._logger.debug('Appended %s', view.name);
        return this;
    },

    /**
     * Get an array of appended subviews
     * @returns {View[]}
     */
    getSubviews: function() {
        return this._subviews;
    },

    _compile: function() {
        var logger = this._logger;
        var args = arguments;

        return when
            .all(
                _.map(this.getSubviews(), function(nestedView) {
                    return nestedView.compile.apply(nestedView, args);
                })
            )
            .then(function(compiledViews) {
                logger.debug('Done compiling nested views');
                logger.verbose('Compiled nested views into %j', compiledViews);
                //Merge an array of compiled views into a single object
                return _.merge.apply(null, [{}].concat(compiledViews));
            });
    }
});
