export const RUM_MARKS = {
    HERO_ELEMENT: '2876',
    BEFORE_JS_FRAMEWORK_INIT: '3070',
    JS_FRAMEWORK_INITED: '3036',
    JS_FRAMEWORK: '3071',
    REACT_INITED: 'react.inited',
    MAIN_JS: '2095',
    CSS: '2447',
    FIRST_MEANINGFUL_PAINT_RAF: 'header'
};

export const sendRumTimeMark = (id) => {
    if (typeof Ya !== 'undefined' && Ya.Rum && typeof Ya.Rum.sendTimeMark === 'function') {
        Ya.Rum.sendTimeMark(id);
    }
};

export const sendRumHeroElement = () => {
    if (typeof Ya !== 'undefined' && Ya.Rum && typeof Ya.Rum.sendHeroElement === 'function') {
        Ya.Rum.sendHeroElement();
    }
};

export const getRumResTimingScipt = (nonce, scripts = [], styles = []) => {
    let rumResTimingScipt = `<script nonce="${nonce}">`;

    scripts.forEach((item = {}) => {
        if (item.key !== 'required') {
            const isLego = item.key.includes('.lego.');
            const isVendors = item.key.includes('.vendors.');
            const id = isLego || isVendors ? RUM_MARKS.JS_FRAMEWORK : RUM_MARKS.MAIN_JS;

            rumResTimingScipt += `typeof Ya !== 'undefined' && Ya.Rum && Ya.Rum.sendResTiming('${id}', '${item.key}');`;
        }
    });

    styles.forEach((item) => {
        // eslint-disable-next-line max-len
        rumResTimingScipt += `typeof Ya !== 'undefined' && Ya.Rum && Ya.Rum.sendResTiming('${RUM_MARKS.CSS}', '${item.key}');`;
    });

    rumResTimingScipt += '</script>';

    return rumResTimingScipt;
};

export const sendRumRaf = (id) => {
    if (typeof Ya !== 'undefined' && Ya.Rum && typeof Ya.Rum.sendRaf === 'function') {
        Ya.Rum.sendRaf(id);
    }
};
