const { Cmd } = require('../components/cmd');
const VaultDataGetter = require('../components/vault-data-getter');
const { yavTokensSecretId, yavGpgKeyName } = require('../lib/secrets');
const TokenGetters = require('../lib/token-getters');

module.exports = {
    name: 'get-gpg-secrets',
    description: 'Получить GPG ключ.',
    setup(command) {
        return command
            .options({
                'oauth-yav': {
                    type: 'string',
                    description: 'OAuth токен для Секретницы. [https://vault-api.passport.yandex.net/docs/#oauth]',
                },
            });
    },
    graph(options) {
        const oauthYav = TokenGetters.getYavToken(options);
        let privateGpgKey = '';

        if (!oauthYav) {
            throw new Error('No yav token was found!');
        }

        const vaultDataGetter = new VaultDataGetter({
            secretID: yavTokensSecretId,
            token: oauthYav,
            cb: data => {
                privateGpgKey = data[yavGpgKeyName];
            },
        });

        const gpgImport = new Cmd({
            name: 'gpgImport',
            deps: [vaultDataGetter.name],
            options: {
                cmd: 'gpg2',
                args: ['--import'],
                stdin: () => privateGpgKey
            }
        });

        return [
            vaultDataGetter,
            gpgImport
        ];
    },
};
