const sh = require('shelljs');

const VaultDataGetter = require('../components/vault-data-getter');
const { yavTokensSecretId, yavSshKeyName, sshKeyFilename } = require('../lib/secrets');
const TokenGetters = require('../lib/token-getters');

module.exports = {
    name: 'get-ssh-key',
    description: 'Получить SSH ключ.',
    setup(command) {
        return command
            .options({
                'oauth-yav': {
                    type: 'string',
                    description: 'OAuth токен для Секретницы. [https://vault-api.passport.yandex.net/docs/#oauth]',
                },
            });
    },
    graph(options) {
        const oauthYav = TokenGetters.getYavToken(options);

        if (!oauthYav) {
            throw new Error('No yav token was found!');
        }

        const vaultDataGetter = new VaultDataGetter({
            secretID: yavTokensSecretId,
            token: oauthYav,
            cb: data => {
                sh.config.fatal = true;
                sh.ShellString(`${data[yavSshKeyName]}\n`).to(sshKeyFilename);
                sh.chmod('400', sshKeyFilename);
                sh.exec(`ssh-add ${sshKeyFilename}`);
            },
        });

        return [
            vaultDataGetter,
        ];
    },
};
