const VaultDataGetter = require('../components/vault-data-getter');
const { yavTokensSecretId } = require('../lib/secrets');
const TokenGetters = require('../lib/token-getters');

module.exports = {
    name: 'get-token',
    description: 'Получить значение токена.',
    setup(command) {
        return command
            .options({
                'oauth-yav': {
                    type: 'string',
                    description: 'OAuth токен для Секретницы. [https://vault-api.passport.yandex.net/docs/#oauth]',
                },
                'token-name': {
                    type: 'string',
                    description: 'Название токена из Секретницы. [https://yav.yandex-team.ru/secret/sec-01f6728tcjgem3q4dphyfxnt84/]',
                    demandOption: true,
                },
            });
    },
    graph(options) {
        const oauthYav = TokenGetters.getYavToken(options);
        const { tokenName } = options;

        if (!oauthYav) {
            throw new Error('No yav token was found!');
        }

        if (!tokenName) {
            throw new Error('No tokenName was found!');
        }

        const vaultDataGetter = new VaultDataGetter({
            secretID: yavTokensSecretId,
            token: oauthYav,
            cb: data => {
                if (!data.hasOwnProperty(tokenName)) {
                    throw new Error('Token in not exist!');
                }

                const token = data[tokenName];

                process.stdout.write(`${token}\n`);
            },
        });

        return [vaultDataGetter];
    },
};
