/* eslint-disable no-console */

const { VaultClient } = require('@yandex-int/vault-client');

/**
 * Компонент, что ходит в Секретницу и исполняет коллбэк с полученными данными.
 * @param {String} name Имя таска для Archon.
 * @param {String} secretID Имя секрета из Секретницы.
 * @param {String} token OAuth-токен для доступа в Секретницу.
 * @param {Function} cb Коллбэк для запуска после получения данных.
 * @param {[String]} deps Список зависимостей для Archon graph.
 */
class VaultDataGetter {
    constructor({ name = 'vault-data-getter', secretID, token, cb = () => { }, deps = [] }) {
        this.name = `${name}-${secretID}`;
        this.secretID = secretID;
        this.token = token;
        this.initTimeout = 300000;
        this.cb = cb;
        this.deps = deps;
    }

    async init() {
        const ret = await this.getVaultData();

        process.stderr.write(`< [${this.name}] Got data!\n`);
        this.cb(ret);

        return ret;
    }

    async getVaultData() {
        if (this.ret) {
            return this.ret;
        }

        const client = new VaultClient(this.token);

        const data = await client.getVersion(this.secretID);

        this.ret = {};

        for (const packet of data) {
            this.ret[packet.key] = packet.value;
        }

        return this.ret;
    }
}

module.exports = VaultDataGetter;
