/* eslint-disable */
const { resolve } = require('path');
const { useCleanUpPlugin } = require('@bem-react/pack/lib/plugins/CleanUpPlugin');
const { useCopyAssetsPlugin } = require('@bem-react/pack/lib/plugins/CopyAssetsPlugin');
const { useCssPlugin } = require('@bem-react/pack/lib/plugins/CssPlugin');
const { useTypeScriptPlugin } = require('@bem-react/pack/lib/plugins/TypeScriptPlugin');
const { usePackageJsonPlugin } = require('@bem-react/pack/lib/plugins/PackageJsonPlugin');

const IS_CI = process.env.TRENDBOX_CI;

/**
 * @type {import('@bem-react/pack/lib/interfaces').Config}
 */
module.exports = {
  silent: IS_CI,

  context: resolve(__dirname, '..'),

  output: './dist',

  plugins: [
    useCleanUpPlugin(['./dist']),

    useTypeScriptPlugin({
      configPath: './tsconfig.prod.json',
      onCreateSideEffects: (file) => {
        const sideEffects = ['*.css'];

        // NOTE: Так как файл темы ничего не экспортирует, а только подключает стили,
        // то необходимо его добавить в сайд эффекты
        if (/^(esm\/)?((?:themes\/.+)|mg-theme)\/index.js$/.test(file)) {
          sideEffects.push('index.js');
        }

        return sideEffects;
      },
    }),

    useCssPlugin({
      context: './src',
      src: './**/*.css',
      output: ['./dist', './dist/esm'],
    }),

    useCopyAssetsPlugin([
      {
        context: './src',
        src: './**/*.{svg,png,md,json,yml}',
        output: ['./dist', './dist/esm'],
      },
      {
        src: ['./readme.md'],
      },
    ]),

    usePackageJsonPlugin({
      scripts: {},
      module: './esm/index.js',
    }),
  ],
};
