import React, { FC, useContext, useEffect, useMemo } from 'react';

import { ThemeContext } from './ThemeContext';
import './mg-theme';
import './themes/default';
import type { ThemeValue } from './types';

export const ThemeProvider: FC<ThemeValue> = (props) => {
  const prevContext = useContext(ThemeContext);
  const { children, theme = 'default', colorScheme = 'light' } = props;
  const context = useMemo(() => ({ theme, colorScheme }), [theme, colorScheme]);
  const isRoot = !(prevContext.colorScheme && prevContext.theme);

  let content = children;

  useEffect(() => {
    if (isRoot) {
      document.body.dataset.theme = theme;
      document.body.dataset.color = colorScheme;
    }
  }, [isRoot, theme, colorScheme]);

  if (!isRoot) {
    content = (
      <div data-theme={theme} data-color={colorScheme}>
        {children}
      </div>
    );
  }

  return <ThemeContext.Provider value={context}>{content}</ThemeContext.Provider>;
};
