import { useContext } from 'react';

import { ThemeContext } from './ThemeContext';
import type { ThemeValue } from './types';

export function useTheme(props: ThemeValue) {
  const { theme, colorScheme } = props;
  const context = useContext(ThemeContext);

  return {
    themeProps: {
      'data-theme': theme ?? context.theme,
      'data-color': colorScheme ?? context.colorScheme,
    },
  };
}
