import { styles as getStyles } from '@figma-export/core';

import { CssVariableFormatter, CssVariableFormatterOptions } from './formatters';

export type Formatter = {
  name: 'css/variable';
  options: CssVariableFormatterOptions;
};

export interface ExportStylesOptions {
  token: string;
  file: string;
  formatters: Formatter[];
}

export async function exportStyles(options: ExportStylesOptions) {
  const { file, token, formatters } = options;

  const styles = await getStyles({ fileId: file, token });

  const promises = formatters.map((formatter) => {
    const instance = getFormatter(formatter);

    return instance.format(styles);
  });

  await Promise.all(promises);
}

function getFormatter(formatter: Formatter) {
  switch (formatter.name) {
    case 'css/variable':
      return new CssVariableFormatter(formatter.options);
  }
}
