module.exports = {
  plugins: ['ascii'],
  extends: [
    './rules/base',
    './rules/typescript',
    './rules/import',
    './rules/react',
    'plugin:prettier/recommended',
  ],
  env: {
    browser: true,
    es6: true,
    node: true,
    jest: true,
    commonjs: true,
  },
  parserOptions: {
    ecmaVersion: 2018,
    useJSXTextNode: true,
  },
  rules: {
    'ascii/valid-name': 'error',
  },
  overrides: [
    {
      files: ['**/*.js'],
      rules: {
        '@typescript-eslint/no-var-requires': 'off',
      },
    },
  ],
};
