import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const BabyOutlineIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.94847 0.684044C9.77382 0.1601 9.2075 -0.12306 8.68356 0.051588C8.15961 0.226236 7.87645 0.792556 8.0511 1.3165C8.24342 1.89344 8.5394 2.35699 8.89282 2.7256C6.58577 3.87027 4.99996 6.24991 4.99996 8.99994V9.00089L4.9993 9.00024C4.60494 9.39479 4.28837 10.0227 4.06492 10.8072C3.45637 12.9439 3.53861 16.2425 4.62151 19.1534C5.63876 21.8878 8.63879 22.9999 11.5563 22.9999H12.4431C15.3605 22.9999 18.3604 21.888 19.3777 19.1537C20.4591 16.2472 20.5427 12.9541 19.9372 10.8171C19.7136 10.028 19.396 9.3965 19 9.0003V8.99994C19 5.13395 15.866 1.99994 12 1.99994C11.9885 1.99994 11.9771 1.99997 11.9657 2.00002C11.194 1.98873 10.2519 1.59447 9.94847 0.684044ZM11.962 4.00008C11.9747 4.00021 11.9873 4.00027 11.9998 4.00027C12.0077 4.00027 12.0157 4.00018 12.0236 3.99999C14.7741 4.01272 17 6.2464 17 8.99994V9.99994H17.9953V9.99998H17C17 10.455 16.8478 10.7186 16.6066 10.9344C16.3194 11.1914 15.8721 11.4052 15.2462 11.6138C14.9415 11.7154 14.622 11.8073 14.2818 11.905L14.2631 11.9103C13.936 12.0042 13.5878 12.1041 13.254 12.2154C12.7535 12.3822 12.1929 12.6022 11.7105 12.9432C11.4313 12.8118 11.156 12.6911 10.888 12.5783C10.5411 12.4322 10.1699 12.2849 9.82462 12.1479C9.59081 12.0551 9.36889 11.967 9.17444 11.8873C8.65109 11.6726 8.22158 11.4774 7.8762 11.2689C7.5326 11.0614 7.32065 10.8689 7.19314 10.6834C7.0768 10.5142 6.99996 10.3074 6.99996 9.99994V8.99994C6.99996 6.25117 9.21807 4.02046 11.962 4.00008ZM5.70191 13.2382C5.72211 12.8475 5.76082 12.4853 5.81386 12.1565C6.11614 12.492 6.47446 12.7588 6.84247 12.981C7.32521 13.2725 7.87227 13.5148 8.41532 13.7376C8.66454 13.8399 8.89948 13.9329 9.13391 14.0257L9.13402 14.0257C9.44966 14.1507 9.7644 14.2753 10.1119 14.4216C11.2627 14.9061 12.3854 15.4769 13.3355 16.3581C14.2702 17.2251 15.0765 18.4291 15.5298 20.2425C15.5423 20.2925 15.5584 20.3406 15.5777 20.3868C14.7326 20.7812 13.6673 20.9999 12.4431 20.9999H11.5563C8.95855 20.9999 7.07594 20.015 6.496 18.4561C5.85827 16.7418 5.61883 14.8453 5.70191 13.2382ZM17.5033 18.4563C17.4355 18.6383 17.35 18.8125 17.2477 18.9783C16.6723 17.1963 15.7668 15.8853 14.6956 14.8918C14.4011 14.6186 14.0964 14.3716 13.7862 14.1468C13.8189 14.1355 13.8523 14.1241 13.8865 14.1127C14.1792 14.0152 14.4921 13.9254 14.8334 13.8274L14.8345 13.8271C15.1678 13.7314 15.5276 13.6282 15.8787 13.5112C16.5653 13.2823 17.3367 12.9648 17.9402 12.4249C18.0276 12.3467 18.1106 12.2646 18.189 12.1784C18.2402 12.5014 18.2777 12.8563 18.2974 13.2384C18.3805 14.8454 18.1411 16.742 17.5033 18.4563ZM10.0001 7.99996C10.5524 7.99996 11.0001 7.55225 11.0001 6.99996C11.0001 6.44768 10.5524 5.99996 10.0001 5.99996C9.44784 5.99996 9.00012 6.44768 9.00012 6.99996C9.00012 7.55225 9.44784 7.99996 10.0001 7.99996ZM15 6.99996C15 7.55225 14.5523 7.99996 14 7.99996C13.4477 7.99996 13 7.55225 13 6.99996C13 6.44768 13.4477 5.99996 14 5.99996C14.5523 5.99996 15 6.44768 15 6.99996ZM10.8357 8.57941C10.4652 8.39416 10.0147 8.54433 9.82943 8.91482C9.64418 9.2853 9.79435 9.7358 10.1648 9.92105C11.376 10.5266 12.6245 10.5266 13.8357 9.92105C14.2061 9.7358 14.3563 9.2853 14.1711 8.91482C13.9858 8.54433 13.5353 8.39416 13.1648 8.57941C12.376 8.97383 11.6245 8.97383 10.8357 8.57941Z"
        fill="currentColor"
      />
    </svg>
  );
});
