import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'
export const CarBlueIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="29"
      height="28"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <g clipPath="url(#a)" fill="#3F8EFF">
        <path opacity=".5" d="M23.321 6.633c-.875-.433-5.25-.866-9.187-.866-3.938 0-8.313.433-9.188.866-.875.434-3.062 5.2-3.062 5.2h24.5s-2.188-4.766-3.063-5.2z" />
        <path d="M19.384 1h-3.063l-.437 3.033h7.438C23.063 2.733 22.009 1 19.384 1zm-10.5 0h3.063l.437 3.033H4.946C5.205 2.733 6.26 1 8.884 1zm19.25 26h-4.813l-.875-3.467H5.822L4.946 27H.134c-.067-3.328.08-6.657.437-9.967h8.313s-.438-2.6-3.063-2.6H1.01c.224-.887.516-1.757.875-2.6 0 0 4.812-.433 12.25-.433s12.25.433 12.25.433c.359.843.651 1.713.875 2.6h-4.813c-2.625 0-3.062 2.6-3.062 2.6h8.313c.358 3.31.504 6.639.437 9.967z" /></g>
      <defs>
        <clipPath id="a">
          <path fill="#fff" transform="translate(.134)" d="M0 0h28v28H0z" />
        </clipPath>
      </defs>
    </svg>
  )
})
