import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const CarOutlineIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.0704 12L4.6641 12.6094C4.23107 13.2589 4 14.0221 4 14.8028V17H20V14.8028C20 14.0221 19.7689 13.2589 19.3359 12.6094L18.9296 12H5.0704ZM17.9604 9.99996L17.3297 6.84659C17.2912 6.65416 17.1437 6.50203 16.9526 6.45762C15.687 6.16359 14.0479 6 12 6C9.95211 6 8.31302 6.16359 7.04742 6.45763C6.85627 6.50204 6.70876 6.65416 6.67027 6.8466L6.03962 9.99996H17.9604ZM4.4 7.99995L4.70911 6.45438C4.90154 5.4922 5.63905 4.73156 6.59482 4.50951C8.05688 4.16984 9.8586 4 12 4C14.1414 4 15.9431 4.16984 17.4052 4.50951C18.3609 4.73156 19.0984 5.49219 19.2909 6.45436L19.6 7.99995H21.0844C21.7349 7.99995 22.1579 8.68447 21.867 9.26626L21.742 9.51626C21.5938 9.8127 21.2908 9.99995 20.9594 9.99995H20.042C20.0906 10.1147 20.15 10.225 20.2195 10.3292L21 11.5C21.6521 12.4781 22 13.6273 22 14.8028V21.25C22 21.6642 21.6642 22 21.25 22H19.6353C19.2687 22 18.9558 21.7349 18.8956 21.3733L18.5 19H5.5L5.10445 21.3733C5.04418 21.7349 4.73128 22 4.36466 22H2.75C2.33579 22 2 21.6642 2 21.25V14.8028C2 13.6273 2.34795 12.4781 3 11.5L3.78053 10.3292C3.85001 10.225 3.90937 10.1147 3.958 9.99995H3.04068C2.70925 9.99995 2.40627 9.8127 2.25805 9.51626L2.13305 9.26626C1.84216 8.68447 2.26522 7.99995 2.91568 7.99995H4.4ZM6.49998 16C7.32841 16 7.99998 15.3284 7.99998 14.5C7.99998 13.6716 7.32841 13 6.49998 13C5.67155 13 4.99998 13.6716 4.99998 14.5C4.99998 15.3284 5.67155 16 6.49998 16ZM19 14.5C19 15.3284 18.3284 16 17.5 16C16.6716 16 16 15.3284 16 14.5C16 13.6716 16.6716 13 17.5 13C18.3284 13 19 13.6716 19 14.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
