import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const CoinsIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <g clipPath="url(#clip0_69_203)">
        <mask id="mask0_69_203" style={{ maskType: 'alpha' }} maskUnits="userSpaceOnUse" x="4" y="10" width="18" height="13">
          <ellipse cx="12.8315" cy="16.4943" rx="8.59142" ry="5.77229" transform="rotate(-15.408 12.8315 16.4943)" fill="#C4C4C4" />
          <ellipse cx="12.8315" cy="16.4943" rx="8.59142" ry="5.77229" transform="rotate(-15.408 12.8315 16.4943)" fill="url(#paint0_linear_69_203)" />
        </mask>
        <g mask="url(#mask0_69_203)">
          <ellipse cx="12.8315" cy="16.4941" rx="8.59142" ry="5.77229" transform="rotate(-15.408 12.8315 16.4941)" fill="url(#paint1_radial_69_203)" />
          <g filter="url(#filter0_f_69_203)">
            <path fillRule="evenodd" clipRule="evenodd" d="M21.0356 13.9597C20.8417 16.6742 17.9256 19.4631 13.8345 20.5906C10.047 21.6344 6.39495 20.9394 4.63825 19.0595C5.66983 21.9393 9.93326 23.2806 14.3652 22.0592C18.9395 20.7985 21.9611 17.2851 21.1141 14.2117C21.0907 14.1265 21.0644 14.0425 21.0356 13.9597Z" fill="#C4C4C4" />
            <path fillRule="evenodd" clipRule="evenodd" d="M21.0356 13.9597C20.8417 16.6742 17.9256 19.4631 13.8345 20.5906C10.047 21.6344 6.39495 20.9394 4.63825 19.0595C5.66983 21.9393 9.93326 23.2806 14.3652 22.0592C18.9395 20.7985 21.9611 17.2851 21.1141 14.2117C21.0907 14.1265 21.0644 14.0425 21.0356 13.9597Z" fill="url(#paint2_radial_69_203)" />
          </g>
          <g filter="url(#filter1_f_69_203)">
            <path fillRule="evenodd" clipRule="evenodd" d="M13.4458 18.9486C17.8918 17.7232 20.925 14.6576 20.2205 12.1013C20.1587 11.877 20.0701 11.664 19.957 11.463C20.2461 11.8078 20.4567 12.1961 20.5746 12.6241C21.2995 15.2543 18.2534 18.388 13.771 19.6233C9.29338 20.8573 5.07628 19.7303 4.34472 17.1061C5.47327 19.2483 9.34433 20.0789 13.4458 18.9486Z" fill="#C4C4C4" />
            <path fillRule="evenodd" clipRule="evenodd" d="M13.4458 18.9486C17.8918 17.7232 20.925 14.6576 20.2205 12.1013C20.1587 11.877 20.0701 11.664 19.957 11.463C20.2461 11.8078 20.4567 12.1961 20.5746 12.6241C21.2995 15.2543 18.2534 18.388 13.771 19.6233C9.29338 20.8573 5.07628 19.7303 4.34472 17.1061C5.47327 19.2483 9.34433 20.0789 13.4458 18.9486Z" fill="#44E0AB" />
          </g>
        </g>
        <mask id="mask1_69_203" style={{ maskType: 'alpha' }} maskUnits="userSpaceOnUse" x="3" y="0" width="16" height="17">
          <ellipse cx="11.4113" cy="8.23534" rx="9.10461" ry="6.11709" transform="rotate(-49.9141 11.4113 8.23534)" fill="#C4C4C4" />
          <ellipse cx="11.4113" cy="8.23534" rx="9.10461" ry="6.11709" transform="rotate(-49.9141 11.4113 8.23534)" fill="url(#paint3_linear_69_203)" />
        </mask>
        <g mask="url(#mask1_69_203)">
          <ellipse cx="11.4113" cy="8.23506" rx="9.10461" ry="6.11709" transform="rotate(-49.9141 11.4113 8.23506)" fill="url(#paint4_radial_69_203)" />
          <g filter="url(#filter2_f_69_203)">
            <path fillRule="evenodd" clipRule="evenodd" d="M17.0545 1.09754C18.5146 3.5845 17.6423 7.77048 14.7465 11.2111C12.0655 14.3965 8.45888 15.982 5.79618 15.3948C8.42589 17.2903 12.9543 15.9022 16.0914 12.175C19.3293 8.32787 19.8588 3.44564 17.2741 1.27019C17.2025 1.20994 17.1293 1.1524 17.0545 1.09754Z" fill="#C4C4C4" />
            <path fillRule="evenodd" clipRule="evenodd" d="M17.0545 1.09754C18.5146 3.5845 17.6423 7.77048 14.7465 11.2111C12.0655 14.3965 8.45888 15.982 5.79618 15.3948C8.42589 17.2903 12.9543 15.9022 16.0914 12.175C19.3293 8.32787 19.8588 3.44564 17.2741 1.27019C17.2025 1.20994 17.1293 1.1524 17.0545 1.09754Z" fill="url(#paint5_radial_69_203)" />
          </g>
          <g filter="url(#filter3_f_69_203)">
            <path fillRule="evenodd" clipRule="evenodd" d="M13.4213 10.0104C16.5685 6.27123 17.3769 1.77317 15.227 -0.0362852C15.0385 -0.194942 14.8335 -0.32766 14.6143 -0.435248C15.0736 -0.307677 15.4904 -0.0950192 15.8503 0.207829C18.0623 2.0696 17.2834 6.63484 14.1106 10.4046C10.941 14.1705 6.58139 15.7179 4.36723 13.865C6.63884 15.0584 10.5181 13.4598 13.4213 10.0104Z" fill="#C4C4C4" />
            <path fillRule="evenodd" clipRule="evenodd" d="M13.4213 10.0104C16.5685 6.27123 17.3769 1.77317 15.227 -0.0362852C15.0385 -0.194942 14.8335 -0.32766 14.6143 -0.435248C15.0736 -0.307677 15.4904 -0.0950192 15.8503 0.207829C18.0623 2.0696 17.2834 6.63484 14.1106 10.4046C10.941 14.1705 6.58139 15.7179 4.36723 13.865C6.63884 15.0584 10.5181 13.4598 13.4213 10.0104Z" fill="#44E0AB" />
          </g>
          <g filter="url(#filter4_f_69_203)">
            <path fillRule="evenodd" clipRule="evenodd" d="M15.5021 11.9932C18.6493 8.25402 19.4577 3.75596 17.3078 1.9465C17.1193 1.78785 16.9143 1.65513 16.6951 1.54754C17.1544 1.67511 17.5712 1.88777 17.9311 2.19062C20.1431 4.05239 19.3642 8.61763 16.1914 12.3874C13.0218 16.1533 8.66221 17.7007 6.44804 15.8478C8.71965 17.0412 12.5989 15.4426 15.5021 11.9932Z" fill="#C4C4C4" />
            <path fillRule="evenodd" clipRule="evenodd" d="M15.5021 11.9932C18.6493 8.25402 19.4577 3.75596 17.3078 1.9465C17.1193 1.78785 16.9143 1.65513 16.6951 1.54754C17.1544 1.67511 17.5712 1.88777 17.9311 2.19062C20.1431 4.05239 19.3642 8.61763 16.1914 12.3874C13.0218 16.1533 8.66221 17.7007 6.44804 15.8478C8.71965 17.0412 12.5989 15.4426 15.5021 11.9932Z" fill="#44E0AB" />
          </g>
        </g>
      </g>
      <defs>
        <filter id="filter0_f_69_203" x="2.96528" y="12.2867" width="19.9642" height="11.8971" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="0.836515" result="effect1_foregroundBlur_69_203" />
        </filter>
        <filter id="filter1_f_69_203" x="3.50821" y="10.6265" width="18.0096" height="10.3337" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="0.418257" result="effect1_foregroundBlur_69_203" />
        </filter>
        <filter id="filter2_f_69_203" x="4.02318" y="-0.675432" width="16.663" height="18.6881" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="0.886483" result="effect1_foregroundBlur_69_203" />
        </filter>
        <filter id="filter3_f_69_203" x="3.4807" y="-1.32172" width="14.515" height="16.8562" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="0.443242" result="effect1_foregroundBlur_69_203" />
        </filter>
        <filter id="filter4_f_69_203" x="5.56151" y="0.661063" width="14.515" height="16.8562" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="0.443242" result="effect1_foregroundBlur_69_203" />
        </filter>
        <linearGradient id="paint0_linear_69_203" x1="-1.00954" y1="7.42356" x2="13.6815" y2="34.0865" gradientUnits="userSpaceOnUse">
          <stop offset="0.171375" stopColor="#34D8CE" />
          <stop offset="1" stopColor="#00B307" />
        </linearGradient>
        <radialGradient id="paint1_radial_69_203" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(15.2845 11.4876) rotate(116.852) scale(11.8842 26.1349)">
          <stop offset="0.135222" stopColor="#05AB5B" />
          <stop offset="0.713451" stopColor="#1AC56C" />
          <stop offset="1" stopColor="#00B307" />
        </radialGradient>
        <radialGradient id="paint2_radial_69_203" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(13.1036 15.5484) rotate(70.7771) scale(8.03585)">
          <stop offset="0.589489" stopColor="#0BAA48" />
          <stop offset="0.847362" stopColor="#008445" />
        </radialGradient>
        <linearGradient id="paint3_linear_69_203" x1="-3.25659" y1="-1.37723" x2="12.312" y2="26.8784" gradientUnits="userSpaceOnUse">
          <stop offset="0.171375" stopColor="#34D8CE" />
          <stop offset="1" stopColor="#00B307" />
        </linearGradient>
        <radialGradient id="paint4_radial_69_203" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(14.0108 2.92958) rotate(116.852) scale(12.5941 27.6961)">
          <stop offset="0.135222" stopColor="#34D8CE" />
          <stop offset="0.713451" stopColor="#1AC56C" />
          <stop offset="1" stopColor="#00B307" />
        </radialGradient>
        <radialGradient id="paint5_radial_69_203" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(11.0811 7.24672) rotate(36.2703) scale(8.51573)">
          <stop offset="0.589489" stopColor="#0BAA48" />
          <stop offset="0.847362" stopColor="#008445" />
        </radialGradient>
        <clipPath id="clip0_69_203">
          <rect width="24" height="24" fill="white" />
        </clipPath>
      </defs>
    </svg>
  )
})
