import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const CoinsGrayIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path d="M14 10.5C19.075 10.5 24.5 8.925 24.5 5.25C24.5 1.575 19.075 0 14 0C8.925 0 3.5 1.575 3.5 5.25C3.5 8.925 8.925 10.5 14 10.5Z" fill="#85889E" />
      <path d="M3.5 11.375V14C3.5 17.675 8.925 19.25 14 19.25C19.075 19.25 24.5 17.675 24.5 14V11.375C22.05 12.95 18.375 14 14 14C9.625 14 5.95 12.95 3.5 11.375Z" fill="#85889E" />
      <path d="M3.5 20.125V22.75C3.5 26.425 8.925 28 14 28C19.075 28 24.5 26.425 24.5 22.75V20.125C22.05 21.875 18.375 22.75 14 22.75C9.625 22.75 5.95 21.7 3.5 20.125Z" fill="#85889E" />
    </svg>
  )
})
