import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const DmsOutlineIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M17.0001 7H20V17H17.0001V7ZM15.0001 7H4V17H15.0001V7ZM2 7C2 5.89543 2.89543 5 4 5H20C21.1046 5 22 5.89543 22 7V17C22 18.1046 21.1046 19 20 19H4C2.89543 19 2 18.1046 2 17V7ZM6.00002 12C6.00002 11.4477 6.44774 11 7.00002 11H8.50012V9.5C8.50012 8.94772 8.94784 8.5 9.50012 8.5C10.0524 8.5 10.5001 8.94772 10.5001 9.5V11H12C12.5523 11 13 11.4477 13 12C13 12.5523 12.5523 13 12 13H10.5001V14.5C10.5001 15.0523 10.0524 15.5 9.50012 15.5C8.94784 15.5 8.50012 15.0523 8.50012 14.5V13H7.00002C6.44774 13 6.00002 12.5523 6.00002 12Z"
        fill="currentColor"
      />
    </svg>
  );
});
