import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const DocumentHorizontalLeftIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>(
  (props, ref) => {
    const { className, size = 24, ...otherProps } = props;

    return (
      <svg
        width={size}
        height={size}
        viewBox="0 0 24 24"
        fill="none"
        {...otherProps}
        focusable="false"
        aria-hidden="true"
        className={'SvgIcon' + (className ? ' ' + className : '')}
        ref={ref}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M4 7H20V17H4V7ZM2 7C2 5.89543 2.89543 5 4 5H20C21.1046 5 22 5.89543 22 7V17C22 18.1046 21.1046 19 20 19H4C2.89543 19 2 18.1046 2 17V7ZM16 15C17.1046 15 18 14.1046 18 13C18 11.8954 17.1046 11 16 11C14.8954 11 14 11.8954 14 13C14 14.1046 14.8954 15 16 15ZM6 10C6 9.44772 6.44772 9 7 9H12C12.5523 9 13 9.44772 13 10C13 10.5523 12.5523 11 12 11H7C6.44772 11 6 10.5523 6 10ZM7 12C6.44772 12 6 12.4477 6 13C6 13.5523 6.44772 14 7 14H11C11.5523 14 12 13.5523 12 13C12 12.4477 11.5523 12 11 12H7Z"
          fill="currentColor"
        />
      </svg>
    );
  },
);
