import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const DocumentVerticalBottomIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>(
  (props, ref) => {
    const { className, size = 24, ...otherProps } = props;

    return (
      <svg
        width={size}
        height={size}
        viewBox="0 0 24 24"
        fill="none"
        {...otherProps}
        focusable="false"
        aria-hidden="true"
        className={'SvgIcon' + (className ? ' ' + className : '')}
        ref={ref}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M6.00098 4H18.001V20H6.00098V4ZM4.00098 4C4.00098 2.89543 4.89641 2 6.00098 2H18.001C19.1055 2 20.001 2.89543 20.001 4V20C20.001 21.1046 19.1055 22 18.001 22H6.00098C4.89641 22 4.00098 21.1046 4.00098 20V4ZM12.001 11.0005C13.1056 11.0005 14.001 10.1051 14.001 9.00049C14.001 7.89592 13.1056 7.00049 12.001 7.00049C10.8965 7.00049 10.001 7.89592 10.001 9.00049C10.001 10.1051 10.8965 11.0005 12.001 11.0005ZM7.99924 13.9999C7.99924 13.4476 8.44696 12.9999 8.99924 12.9999H14.9992C15.5515 12.9999 15.9992 13.4476 15.9992 13.9999C15.9992 14.5522 15.5515 14.9999 14.9992 14.9999H8.99924C8.44696 14.9999 7.99924 14.5522 7.99924 13.9999ZM9.99881 15.9999C9.44652 15.9999 8.99881 16.4476 8.99881 16.9999C8.99881 17.5522 9.44652 17.9999 9.99881 17.9999H13.9988C14.5511 17.9999 14.9988 17.5522 14.9988 16.9999C14.9988 16.4476 14.5511 15.9999 13.9988 15.9999H9.99881Z"
          fill="currentColor"
        />
      </svg>
    );
  },
);
