import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const DriverLicenseIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 7C2 5.89543 2.89543 5 4 5H20C21.1046 5 22 5.89543 22 7V18C22 19.1046 21.1046 20 20 20H4C2.89543 20 2 19.1046 2 18V7ZM4 7H20V18H4V17.9992C5.86808 17.9984 8.37446 17.9987 10.6468 17.999L13.5676 17.9992C13.5676 17.7526 13.2998 16.7193 12.8849 16.2766C12.5082 15.8746 11.6403 15.2619 10.5059 14.9147C10.252 15.1979 9.72259 15.6073 8.78382 15.6073C7.84533 15.6073 7.31598 15.1981 7.062 14.915C5.92791 15.2622 5.0603 15.8747 4.68369 16.2766C4.26876 16.7193 4 17.7526 4 17.9992V7ZM10.0639 8.74974C10.4334 8.83098 10.7487 8.90027 11.0411 8.84545C11.0411 8.84545 11.1846 9.68873 10.7182 10.2995C10.8095 10.5835 10.8566 10.8919 10.8566 11.2094C10.8566 11.2723 10.8556 11.3352 10.8536 11.3978C11.2516 11.3744 11.4327 11.9433 11.1763 12.5377C11.0357 12.8637 10.7408 13.1055 10.527 13.084C10.1868 13.9501 9.59214 14.5581 8.78448 14.5581C7.97433 14.5581 7.3491 13.9463 6.98668 13.0759C6.77134 13.1476 6.43843 12.8934 6.2862 12.5405C6.02629 11.938 6.21592 11.3618 6.62524 11.4019L6.63761 11.4032L6.63624 11.3605C6.04524 9.28272 7.79691 8.58203 8.81561 8.58203C9.30097 8.58203 9.70766 8.67143 10.0639 8.74974ZM13 11C13 10.4477 13.4477 10 14 10H17C17.5523 10 18 10.4477 18 11C18 11.5523 17.5523 12 17 12H14C13.4477 12 13 11.5523 13 11ZM15 13C14.4477 13 14 13.4477 14 14C14 14.5523 14.4477 15 15 15H17C17.5523 15 18 14.5523 18 14C18 13.4477 17.5523 13 17 13H15Z"
        fill="currentColor"
      />
    </svg>
  );
});
