import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const FamilyCardIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="37"
      height="28"
      viewBox="0 0 37 28"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <g clipPath="url(#clip0_6587_33578)">
        <rect x="0.133789" width="36" height="28" rx="8" fill="url(#paint0_radial_6587_33578)" />
        <path d="M18.5253 20.5787C18.2864 20.7419 17.9803 20.7419 17.7414 20.5787C16.3296 19.6141 11.5879 16.1292 11.5879 12.8343C11.5879 8.43333 16.7261 7.72839 18.1333 10.6931C19.5406 7.72839 24.6788 8.43333 24.6788 12.8343C24.6788 16.1292 19.9371 19.6141 18.5253 20.5787Z" fill="white" />
        <path d="M5.58789 12.8343C5.58789 15.0765 6.38029 16.9625 7.15959 18.3072C7.95391 19.6779 8.94221 20.8445 9.82901 21.7585C11.5972 23.5808 13.5114 24.9553 14.3566 25.5328C16.6366 27.0905 19.6301 27.0905 21.9101 25.5328C22.7553 24.9553 24.6695 23.5808 26.4377 21.7585C27.3245 20.8445 28.3128 19.6779 29.1071 18.3072C29.8864 16.9625 30.6788 15.0765 30.6788 12.8343C30.6788 5.54001 23.7061 1.49117 18.1333 3.22605C12.5606 1.49117 5.58789 5.54001 5.58789 12.8343Z" stroke="white" strokeOpacity="0.1" strokeWidth="12" strokeLinejoin="round" />
        <path d="M18.5253 20.5787C18.2864 20.7419 17.9803 20.7419 17.7414 20.5787C16.3296 19.6141 11.5879 16.1292 11.5879 12.8343C11.5879 8.43333 16.7261 7.72839 18.1333 10.6931C19.5406 7.72839 24.6788 8.43333 24.6788 12.8343C24.6788 16.1292 19.9371 19.6141 18.5253 20.5787Z" fill="white" />
        <path d="M7.08789 12.8343C7.08789 14.7219 7.75628 16.3453 8.4574 17.5551C9.1698 18.7844 10.0702 19.853 10.9056 20.7139C12.5721 22.4316 14.3924 23.7406 15.2028 24.2943C16.9725 25.5034 19.2942 25.5034 21.0639 24.2943C21.8743 23.7406 23.6945 22.4316 25.3611 20.7139C26.1965 19.853 27.0969 18.7844 27.8093 17.5551C28.5104 16.3453 29.1788 14.7219 29.1788 12.8343C29.1788 6.3621 22.8821 3.00014 18.1333 4.84954C13.3846 3.00014 7.08789 6.3621 7.08789 12.8343Z" stroke="white" strokeOpacity="0.1" strokeWidth="9" strokeLinejoin="round" />
        <path d="M18.5253 20.5787C18.2864 20.7419 17.9803 20.7419 17.7414 20.5787C16.3296 19.6141 11.5879 16.1292 11.5879 12.8343C11.5879 8.43333 16.7261 7.72839 18.1333 10.6931C19.5406 7.72839 24.6788 8.43333 24.6788 12.8343C24.6788 16.1292 19.9371 19.6141 18.5253 20.5787Z" fill="white" />
        <path d="M8.58789 12.8343C8.58789 14.3672 9.13227 15.7281 9.75522 16.803C10.3857 17.8909 11.1982 18.8615 11.9821 19.6694C13.5471 21.2824 15.2734 22.5259 16.049 23.0557C17.3084 23.9162 18.9583 23.9162 20.2177 23.0557C20.9933 22.5258 22.7196 21.2824 24.2846 19.6694C25.0685 18.8615 25.881 17.8909 26.5115 16.803C27.1344 15.7281 27.6788 14.3672 27.6788 12.8343C27.6788 7.16351 22.0164 4.52363 18.1333 6.53002C14.2503 4.52363 8.58789 7.16351 8.58789 12.8343Z" stroke="white" strokeOpacity="0.1" strokeWidth="6" strokeLinejoin="round" />
        <path d="M18.5253 20.5787C18.2864 20.7419 17.9803 20.7419 17.7414 20.5787C16.3296 19.6141 11.5879 16.1292 11.5879 12.8343C11.5879 8.43333 16.7261 7.72839 18.1333 10.6931C19.5406 7.72839 24.6788 8.43333 24.6788 12.8343C24.6788 16.1292 19.9371 19.6141 18.5253 20.5787Z" fill="white" />
        <path d="M10.0879 12.8343C10.0879 14.0126 10.5083 15.1108 11.053 16.0509C11.6016 16.9974 12.3263 17.87 13.0587 18.6249C14.5221 20.1332 16.1545 21.3111 16.8952 21.8172C17.6443 22.329 18.6224 22.329 19.3715 21.8172C20.1122 21.3111 21.7446 20.1332 23.208 18.6249C23.9404 17.87 24.6651 16.9974 25.2137 16.0509C25.7584 15.1108 26.1788 14.0126 26.1788 12.8343C26.1788 7.91457 21.045 6.07811 18.1333 8.339C15.2217 6.07811 10.0879 7.91457 10.0879 12.8343Z" stroke="white" strokeOpacity="0.2" strokeWidth="3" strokeLinejoin="round" />
      </g>
      <defs>
        <radialGradient id="paint0_radial_6587_33578" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(18.1338 14) rotate(-180) scale(19.6364 19.7647)">
          <stop offset="0.192125" stopColor="#FF7A00" />
          <stop offset="0.753156" stopColor="#FF0B0B" />
          <stop offset="1" stopColor="#FD0098" />
        </radialGradient>
        <clipPath id="clip0_6587_33578">
          <rect x="0.133789" width="36" height="28" rx="8" fill="white" />
        </clipPath>
      </defs>
    </svg>
  )
})
