import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './FnpWhite.css'
export const FnpWhiteIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'FnpWhiteIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
