import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './GlobexDefault.css'
export const GlobexDefaultIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'GlobexDefaultIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
