import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const HomeGrayIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path fillRule="evenodd" clipRule="evenodd" d="M3.1064 7.47152L13.2202 0.702444C13.6639 0.303124 14.3374 0.303124 14.7811 0.702444L24.8949 7.47152C25.3866 7.91402 25.6673 8.54441 25.6673 9.20588V23.3334C25.6673 24.622 24.6233 25.6667 23.3347 25.6667C21.1874 25.6667 17.7801 25.6667 14.067 25.6667C10.3262 25.6667 6.8481 25.6667 4.66555 25.6667C3.37688 25.6667 2.33398 24.622 2.33398 23.3334V9.20588C2.33398 8.54441 2.61473 7.91402 3.1064 7.47152ZM10.5007 16.3334V24.5H17.5007V16.3334C17.5007 15.689 16.9783 15.1667 16.334 15.1667H11.6673C11.023 15.1667 10.5007 15.689 10.5007 16.3334Z" fill="#85889E" />
    </svg>
  )
})
