import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './JugraDefault.css'
export const JugraDefaultIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'JugraDefaultIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
