import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './MdmDefault.css'
export const MdmDefaultIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'MdmDefaultIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
