import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const MedicineIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.0771 8H16V4.92291C16 4.16234 15.9181 3.73825 15.6815 3.29577C15.4575 2.87705 15.1229 2.54247 14.7042 2.31854C14.2618 2.0819 13.8377 2 13.0771 2H10.9229C10.1623 2 9.73825 2.0819 9.29577 2.31854C8.87705 2.54247 8.54247 2.87705 8.31854 3.29577C8.0819 3.73825 8 4.16234 8 4.92291V8H4.92291C4.16234 8 3.73825 8.0819 3.29577 8.31854C2.87705 8.54247 2.54247 8.87705 2.31854 9.29577C2.0819 9.73825 2 10.1623 2 10.9229V13.0771C2 13.8377 2.0819 14.2618 2.31854 14.7042C2.54247 15.1229 2.87705 15.4575 3.29577 15.6815C3.73825 15.9181 4.16234 16 4.92291 16H8V19.0771C8 19.8377 8.0819 20.2618 8.31854 20.7042C8.54247 21.1229 8.87705 21.4575 9.29577 21.6815C9.73825 21.9181 10.1623 22 10.9229 22H13.0771C13.8377 22 14.2618 21.9181 14.7042 21.6815C15.1229 21.4575 15.4575 21.1229 15.6815 20.7042C15.9181 20.2618 16 19.8377 16 19.0771V16H19.0771C19.8377 16 20.2618 15.9181 20.7042 15.6815C21.1229 15.4575 21.4575 15.1229 21.6815 14.7042C21.9181 14.2618 22 13.8377 22 13.0771V10.9229C22 10.1623 21.9181 9.73825 21.6815 9.29577C21.4575 8.87705 21.1229 8.54247 20.7042 8.31854C20.2618 8.0819 19.8377 8 19.0771 8ZM14 9C14 9.55228 14.4477 10 15 10H19.0771C19.5357 10 19.6479 10.0217 19.761 10.0822C19.8312 10.1197 19.8803 10.1688 19.9178 10.239C19.9783 10.3521 20 10.4643 20 10.9229V13.0771C20 13.5357 19.9783 13.6479 19.9178 13.761C19.8803 13.8312 19.8312 13.8803 19.761 13.9178C19.6479 13.9783 19.5357 14 19.0771 14H15C14.4477 14 14 14.4477 14 15V19.0771C14 19.5357 13.9783 19.6479 13.9178 19.761C13.8803 19.8312 13.8312 19.8803 13.761 19.9178C13.6479 19.9783 13.5357 20 13.0771 20H10.9229C10.4643 20 10.3521 19.9783 10.239 19.9178C10.1688 19.8803 10.1197 19.8312 10.0822 19.761C10.0217 19.6479 10 19.5357 10 19.0771V15C10 14.4477 9.55228 14 9 14H4.92291C4.46427 14 4.35209 13.9783 4.23896 13.9178C4.16879 13.8803 4.11969 13.8312 4.08216 13.761C4.02166 13.6479 4 13.5357 4 13.0771V10.9229C4 10.4643 4.02166 10.3521 4.08216 10.239C4.11969 10.1688 4.16879 10.1197 4.23896 10.0822C4.35209 10.0217 4.46427 10 4.92291 10H9C9.55228 10 10 9.55228 10 9V4.92291C10 4.46427 10.0217 4.35209 10.0822 4.23896C10.1197 4.16879 10.1688 4.11969 10.239 4.08216C10.3521 4.02166 10.4643 4 10.9229 4H13.0771C13.5357 4 13.6479 4.02166 13.761 4.08216C13.8312 4.11969 13.8803 4.16879 13.9178 4.23896C13.9783 4.35209 14 4.46427 14 4.92291V9Z"
        fill="currentColor"
      />
    </svg>
  );
});
