import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './MfkDefault.css'
export const MfkDefaultIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'MfkDefaultIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
