import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const PassportIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.0005 4.30469C12.8289 4.30469 13.5005 3.63311 13.5005 2.80469C13.5005 1.97626 12.8289 1.30469 12.0005 1.30469C11.1721 1.30469 10.5005 1.97626 10.5005 2.80469C10.5005 3.63311 11.1721 4.30469 12.0005 4.30469ZM11.9989 23.4988L11.9999 23.4998L12.001 23.4991C12.2846 23.2163 12.8495 23.0936 13.5124 22.9495C14.803 22.669 16.468 22.3071 17.1677 20.5245C17.3113 20.1588 17.4142 19.7334 17.465 19.2366C17.4885 19.0067 17.5008 18.7616 17.5008 18.5001C17.0059 18.5439 16.5922 18.5393 16.2465 18.5001C16.0123 18.4735 15.8092 18.431 15.6332 18.377C15.4942 18.3343 15.372 18.2843 15.2646 18.2292C14.3959 17.7831 14.5003 17.0004 14.5003 17.0004C14.5003 15.9092 16.0003 16.0404 16.0003 17.0004C16.1671 17.0448 16.3313 17.0829 16.4926 17.1147L16.497 17.1156C16.8041 17.176 17.1013 17.214 17.3884 17.2312C17.9428 17.2643 18.4597 17.2199 18.9384 17.1096C23.936 15.9586 24.7674 7.63366 20.5001 5.50002L16.0001 10C15.5001 10.5 14.1263 10.1488 14.2217 9.36503C14.5153 6.9521 16.191 6.60356 16.5001 7.4993C17.1391 7.23816 17.4249 6.53953 17.2246 5.94711C17.0893 5.54672 16.7319 5.19484 16.1115 5.05932C16.0574 5.04749 16.0012 5.03731 15.943 5.02889C15.813 5.01008 15.6729 5.00005 15.5223 5.00005L15.3255 5.00004C14.8317 4.99994 14.4547 4.99906 14.1594 4.9909C13.8603 4.98263 13.6451 4.96689 13.4772 4.93693C13.4301 4.92852 13.3868 4.91901 13.3464 4.90822C13.3264 4.91893 13.3221 4.93996 13.3304 4.96802C13.3462 5.02121 13.4072 5.09968 13.4927 5.18106C13.6278 5.30951 13.8239 5.44524 13.9994 5.50036C13.9231 5.57106 13.8497 5.64262 13.7791 5.71486C12.2205 7.30956 12.0212 9.23141 12.0019 9.47464C12.0708 12.1292 15.5635 13.265 17.4144 11.4142L20.6086 8.21994C20.7853 8.49715 20.9321 8.8233 21.0427 9.19837C21.3261 10.1597 21.324 11.3169 21.0162 12.3825C20.708 13.4496 20.1405 14.2738 19.4483 14.7431C18.9516 15.0798 18.2833 15.3096 17.368 15.2244C16.8346 14.5997 16.0469 14.2641 15.3377 14.2331C14.7106 14.2057 13.987 14.3889 13.3992 14.9163C12.8056 15.4487 12.5249 16.1748 12.5018 16.9024C12.4988 16.9513 12.4966 17.007 12.4964 17.0687C12.4958 17.2152 12.5059 17.4025 12.5431 17.6167C12.6178 18.0474 12.8074 18.6121 13.255 19.1446C13.7074 19.6828 14.2969 20.0527 14.9978 20.2741C14.9628 20.308 14.9296 20.3357 14.8997 20.3591C14.5316 20.6485 14.0001 20.7968 13.0876 20.9951L13.0444 21.0045C12.7465 21.0692 12.3555 21.154 12.0001 21.2689C11.6446 21.154 11.2537 21.0691 10.9557 21.0044L10.9128 20.9951C10.0002 20.7968 9.46873 20.6485 9.10059 20.3591C9.07076 20.3357 9.03755 20.3079 9.00248 20.2741C9.70343 20.0527 10.2929 19.6828 10.7453 19.1446C11.1929 18.6121 11.3826 18.0474 11.4573 17.6167C11.4944 17.4025 11.5045 17.2152 11.5039 17.0687C11.5037 17.007 11.5016 16.9513 11.4985 16.9024C11.4755 16.1748 11.1948 15.4487 10.6012 14.9162C10.0133 14.3889 9.28974 14.2056 8.66267 14.2331C7.95345 14.2641 7.16574 14.5997 6.63237 15.2244C5.71706 15.3096 5.04868 15.0798 4.55206 14.7431C3.85979 14.2738 3.29235 13.4496 2.9841 12.3825C2.67628 11.3169 2.67423 10.1597 2.95762 9.19835C3.06819 8.82328 3.21501 8.49713 3.39169 8.21993L6.58597 11.4142C8.43765 13.2659 11.9302 12.1282 11.9983 9.47297C11.9782 9.22282 11.7764 7.30598 10.2212 5.71484C10.1506 5.64261 10.0772 5.57104 10.0009 5.50034C10.1764 5.44522 10.3726 5.3095 10.5076 5.18105C10.5931 5.09966 10.6542 5.0212 10.6699 4.96801C10.6782 4.93994 10.6739 4.91891 10.654 4.9082C10.6135 4.91899 10.5702 4.92851 10.5231 4.93691C10.3552 4.96687 10.14 4.98261 9.84095 4.99088C9.54568 4.99905 9.16867 4.99992 8.67481 5.00002L8.47802 5.00003C8.32743 5.00003 8.18729 5.01006 8.05728 5.02888C7.9991 5.0373 7.94296 5.04748 7.88881 5.0593C7.2684 5.19482 6.91104 5.5467 6.7757 5.94709C6.57545 6.53951 6.86126 7.23814 7.50019 7.49928C7.80931 6.60355 9.48504 6.95209 9.77868 9.36502C9.87405 10.1488 8.50019 10.5 8.00019 10L3.50019 5.5C-0.7671 7.63364 0.0643362 15.9586 5.06194 17.1096C5.54063 17.2199 6.05756 17.2643 6.61188 17.2312C6.89904 17.214 7.19624 17.176 7.50337 17.1156L7.5077 17.1147C7.66908 17.0829 7.8332 17.0448 8.00004 17.0003C8.00004 16.0403 9.50004 15.9092 9.50004 17.0003C9.50004 17.0003 9.60446 17.7831 8.73569 18.2291C8.62836 18.2843 8.50616 18.3342 8.36708 18.377C8.19109 18.431 7.98806 18.4735 7.75386 18.5C7.4081 18.5393 6.99441 18.5438 6.49955 18.5C6.49955 18.7616 6.51187 19.0067 6.53536 19.2366C6.58611 19.7334 6.68904 20.1588 6.83259 20.5244C7.53237 22.3071 9.19737 22.669 10.488 22.9495C11.1509 23.0936 11.715 23.2162 11.9989 23.4988Z"
        fill="currentColor"
      />
    </svg>
  );
});
