import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const PayServiceIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props;

  return (
    <svg
      width="69"
      height="28"
      viewBox="0 0 69 28"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M55 1.25H14C6.95837 1.25 1.25 6.95837 1.25 14C1.25 21.0416 6.95837 26.75 14 26.75H55C62.0416 26.75 67.75 21.0416 67.75 14C67.75 6.95837 62.0416 1.25 55 1.25ZM14 0C6.26801 0 0 6.26801 0 14C0 21.732 6.26801 28 14 28H55C62.732 28 69 21.732 69 14C69 6.26801 62.732 0 55 0H14Z"
        fill="currentColor"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M29.8965 8.71799V13.0723H31.7869C32.3605 13.0853 32.8559 13.0071 33.273 12.8637C33.6772 12.7203 34.0031 12.4857 34.2117 12.1597C34.4203 11.8338 34.5376 11.4036 34.5376 10.8691C34.5376 10.139 34.329 9.6045 33.8988 9.2525C33.4816 8.9005 32.8037 8.71799 31.9042 8.71799H29.8965ZM29.8965 19.3691V15.0539H31.7738C32.9211 15.0539 33.9119 14.9105 34.7071 14.6367C35.5024 14.363 36.1281 13.9197 36.5714 13.307C37.0146 12.6942 37.2363 11.886 37.2363 10.8691C37.2363 9.5002 36.793 8.47029 35.8935 7.79237C34.9939 7.10141 33.6251 6.76245 31.7869 6.76245H29.8965H28.5407H27.25V19.3691H29.8965ZM47.9396 17.1397C47.9396 17.5171 47.9526 17.8815 47.9656 18.2458L47.9657 18.2478C47.9787 18.6127 48.0178 18.9907 48.0569 19.3686V19.3686L48.0569 19.369H45.5147C45.4886 19.2777 45.4496 19.1343 45.4104 18.9648C45.3583 18.7954 45.3322 18.6259 45.3061 18.4564H45.2149C44.9932 18.6259 44.7586 18.7954 44.4848 18.9518C44.211 19.1213 43.8721 19.2517 43.4679 19.3429C43.0638 19.4472 42.5684 19.4994 41.9947 19.4994C40.9779 19.4994 40.1696 19.2517 39.5568 18.7563C38.9441 18.2609 38.6443 17.5569 38.6443 16.6573C38.6443 15.9403 38.8529 15.3667 39.257 14.9234C39.6612 14.4802 40.3 14.1412 41.1473 13.9456C41.9947 13.7501 43.1159 13.6328 44.4718 13.6328H45.3061V13.2677C45.3061 12.9548 45.2279 12.6941 45.0584 12.4855C44.8889 12.2769 44.6543 12.1335 44.3284 12.0553C44.0024 11.9771 43.6244 11.938 43.155 11.938C42.6727 11.938 42.1903 11.9771 41.6949 12.0553C41.1995 12.1335 40.7562 12.2378 40.3651 12.3682C39.974 12.4985 39.6481 12.6289 39.4004 12.7593V10.8689C39.8046 10.6603 40.3652 10.4778 41.0822 10.3344C41.7992 10.178 42.6205 10.1128 43.5592 10.1128C44.55 10.1128 45.3713 10.2041 46.0101 10.4126C46.6489 10.6082 47.1313 10.9472 47.4572 11.4165C47.7831 11.8858 47.9396 12.5116 47.9396 13.2808V17.1397ZM45.3192 15.1711H44.537C43.7547 15.1711 43.129 15.2102 42.6596 15.3015C42.1903 15.3927 41.8513 15.5361 41.6428 15.7317C41.4342 15.9403 41.3299 16.2141 41.3299 16.5661C41.3299 16.8268 41.395 17.0615 41.5124 17.244C41.6297 17.4265 41.8253 17.5699 42.073 17.6742C42.3207 17.7785 42.6466 17.8437 43.0377 17.8437C43.5592 17.8437 44.0024 17.7524 44.3935 17.5829C44.7716 17.4135 45.0845 17.1788 45.3322 16.8789V15.1711H45.3192ZM50.9902 20.0472V21.9375C51.4726 22.107 51.981 22.1852 52.5155 22.1722C53.0631 22.1722 53.5585 22.107 53.9626 21.9897C54.3798 21.8723 54.7448 21.6768 55.0707 21.403C55.3967 21.1292 55.6835 20.8033 55.9573 20.3992C56.218 19.995 56.4657 19.5257 56.7004 18.9651L60.3898 10.2434H57.8867L55.2183 17.0764L52.3721 10.2434H49.6344L53.8186 19.5765C53.7597 19.6713 53.6995 19.7587 53.6367 19.8386C53.4933 20.0211 53.3108 20.1645 53.1022 20.2557C52.8936 20.347 52.6329 20.3861 52.32 20.3861C52.0201 20.3861 51.7724 20.36 51.5638 20.2949C51.3422 20.2427 51.1597 20.1515 50.9902 20.0472Z"
        fill="currentColor"
      />
      <path
        d="M5 14C5 9.02944 9.02944 5 14 5V5C18.9706 5 23 9.02944 23 14V14C23 18.9706 18.9706 23 14 23V23C9.02944 23 5 18.9706 5 14V14Z"
        fill="#FC3F1D"
      />
      <path
        d="M15.2682 19.4091H17.1485V8.60906H14.4136C11.6631 8.60906 10.2179 10.0232 10.2179 12.1055C10.2179 13.7682 11.0104 14.7472 12.4245 15.7573L9.96924 19.4091H12.0049L14.7399 15.3222L13.792 14.685C12.642 13.9081 12.0826 13.302 12.0826 11.9967C12.0826 10.8468 12.8907 10.0698 14.4291 10.0698H15.2682V19.4091Z"
        fill="white"
      />
    </svg>
  );
});
