import React, { forwardRef } from 'react';

import { IconSvgProps } from '../types';

export const PlaneIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.4148 4.85191C20.5229 4.76185 21.7085 4.96063 22.5532 5.71902C22.749 5.89478 22.8676 6.14061 22.8834 6.40323C23.0085 8.48816 21.7097 10.0098 20.2256 11.1656C19.1352 12.0148 17.7715 12.7942 16.4876 13.5279C16.1872 13.6996 15.8912 13.8688 15.6041 14.0357L14.8512 20.1002C14.8045 20.4767 14.5487 20.7943 14.1908 20.9203L11.0691 22.0186C10.7563 22.1286 10.4094 22.0765 10.1428 21.8794C9.87616 21.6823 9.72456 21.3659 9.73803 21.0346L9.92959 16.3248L6.10055 17.7715C5.66694 17.9353 5.17758 17.7797 4.91826 17.3955L1.96588 13.0214C1.66896 12.5814 1.76743 11.9862 2.19022 11.6653L3.97541 10.3105C4.32913 10.0421 4.81752 10.0391 5.17455 10.3031L6.89387 11.5746C7.30259 11.3287 7.70425 11.0842 8.10345 10.8393L4.80915 7.02828C4.61744 6.8065 4.5327 6.51177 4.57734 6.22204C4.62198 5.93231 4.7915 5.67676 5.04108 5.52297L7.48715 4.01571C7.8265 3.8066 8.25763 3.819 8.5844 4.04726L13.5084 7.48684C14.282 7.01267 15.102 6.51585 15.9888 5.98832L15.9889 5.98825C17.0703 5.34513 18.2825 4.94394 19.4148 4.85191ZM11.6555 8.63213L7.97736 6.06285L7.0906 6.60927L9.82546 9.77307C10.0743 9.61806 10.3247 9.46183 10.5778 9.30391C10.6649 9.24955 10.7523 9.19499 10.8401 9.14022C11.1083 8.97294 11.3797 8.80374 11.6555 8.63213ZM17.0112 7.70725C15.0589 8.86864 13.4325 9.8803 11.8987 10.8371C11.8096 10.8927 11.7208 10.9481 11.6322 11.0034C10.198 11.8983 8.83019 12.7517 7.3466 13.6344C7.00044 13.8404 6.56451 13.8186 6.24066 13.5791L4.58768 12.3566L4.15287 12.6866L6.13353 15.6211L10.6368 13.9197C10.9507 13.8011 11.3032 13.8478 11.5754 14.0442C11.8475 14.2406 12.003 14.5604 11.9894 14.8958L11.7963 19.6425L12.9428 19.2392L13.6801 13.3002C13.7181 12.9936 13.8957 12.7219 14.1612 12.5639C14.6507 12.2727 15.1377 11.9943 15.6146 11.7218C16.8558 11.0122 18.0281 10.3421 18.9967 9.58771C20.1272 8.70727 20.7488 7.88242 20.8696 6.99594C20.5653 6.86942 20.1355 6.79993 19.5768 6.84534C18.7785 6.91022 17.8578 7.2038 17.0113 7.70718"
        fill="currentColor"
      />
    </svg>
  );
});
