import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const PlusGradientIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path fillRule="evenodd" clipRule="evenodd" d="M12 23C18.0751 23 23 18.0751 23 12C23 11.7609 22.9924 11.5236 22.9773 11.2883H16.7915L15.3679 18.0824H12.165L13.6209 11.2883H7.2797L7.92676 8.37655H14.2356L15.6449 1.61825C14.5042 1.21778 13.2775 1 12 1C5.92487 1 1 5.92487 1 12C1 18.0751 5.92487 23 12 23ZM18.5292 3.14643C20.2928 4.44924 21.6534 6.26647 22.3893 8.37655H17.4385L18.5292 3.14643Z" fill="url(#paint0_linear_69_199)" />
      <defs>
        <linearGradient id="paint0_linear_69_199" x1="1" y1="10.5333" x2="23" y2="10.5333" gradientUnits="userSpaceOnUse">
          <stop stopColor="#F74D63" />
          <stop offset="1" stopColor="#844FD0" />
        </linearGradient>
      </defs>
    </svg>
  )
})
