import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './RocketbankDefault.css'
export const RocketbankDefaultIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'RocketbankDefaultIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
