import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'

export const ScaleGrayIcon = forwardRef<SVGSVGElement, IconSvgProps>((props, ref) => {
  const { className, ...otherProps } = props
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      {...otherProps}
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path d="M21.875 24.5H6.125V26.25H21.875V24.5Z" fill="#85889E" />
      <path d="M27.853 12.6394L22.603 4.76438C22.4403 4.52113 22.1672 4.375 21.875 4.375H14.875V2.625C14.875 2.14113 14.483 1.75 14 1.75C13.517 1.75 13.125 2.14113 13.125 2.625V4.375H6.125C5.83275 4.375 5.55975 4.52113 5.397 4.76438L0.147 12.6394C0.051625 12.7829 0 12.9526 0 13.125C0 15.6502 2.3415 18.375 6.125 18.375C9.9085 18.375 12.25 15.6502 12.25 13.125C12.25 12.9526 12.1984 12.7829 12.103 12.6394L7.76038 6.125H13.125V22.75H14.875V6.125H20.2396L15.897 12.6394C15.8016 12.7829 15.75 12.9526 15.75 13.125C15.75 15.6502 18.0915 18.375 21.875 18.375C25.6585 18.375 28 15.6502 28 13.125C28 12.9526 27.9484 12.7829 27.853 12.6394ZM9.73962 12.25H2.51037L6.125 6.82762L9.73962 12.25ZM18.2604 12.25L21.875 6.82762L25.4896 12.25H18.2604Z" fill="#85889E" />
    </svg>
  )
})
