import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './TatfondbankWhite.css'
export const TatfondbankWhiteIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'TatfondbankWhiteIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
