/* This file was created automatically, don't change it manually. */
import React, { forwardRef } from 'react'
import { IconSvgProps } from '../types'
export const TinkoffDefaultIcon = forwardRef<SVGSVGElement, IconSvgProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 32 32"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M30.611 15.14 31 13.9l-1.288.04c-.11 0-.9-.022-1.667-.575.057.005.114.013.173.013.79 0 1.555-.473 1.86-1.15l.554-1.224c-.694.01-1.33-.079-1.33-.079-.005 0-.506-.064-1.084-.653-.416-.422-.929-.645-1.486-.645-.22 0-.44.035-.648.103.029-.1.056-.2.072-.303.177-1.146-.563-2.018-.563-2.017l-.97-1.196-.6 1.402c-.002.005-.154.334-.425.495a2.602 2.602 0 0 0-.712-1.32 3.206 3.206 0 0 0-2.313-.96c-.24 0-.411.026-.452.033l-1.17.23c.1-.395.26-.773.474-1.121l.646-1-1.624.183-.517-1.092-1.001.513-.927-.91-.923.91-1.004-.513-.516 1.092-1.623-.184.646 1c.264.408.407.86.473 1.12l-1.116-.22-.039-.005a2.937 2.937 0 0 0-.464-.035c-.517 0-1.503.125-2.312.96A2.606 2.606 0 0 0 8.41 8.11c-.27-.16-.42-.484-.42-.484l-.602-1.41-.984 1.202c-.12.155-.713.976-.551 2.008.017.102.04.203.071.302a2.127 2.127 0 0 0-.648-.104c-.556 0-1.07.224-1.485.646-.578.586-1.075.653-1.072.653 0 0-.526.094-1.34.079l.55 1.223c.307.678 1.072 1.151 1.86 1.151.06 0 .117-.01.175-.013-.48.349-1.056.55-1.653.577L1 13.899l.398 1.24c.2.639.868 1.698 2.147 1.812-.14.58-.448 1.232-1.126 1.511l-.977.4.532.925c.301.497 1.008 1.08 2.013 1.08.218 0 .428-.022.63-.065.051.227.116.455.193.682.299.887.041 1.505.038 1.512L4.365 24l1.077.283c.014.004.339.093.746.093.305.003.608-.056.889-.173.139.25.31.476.506.68.69.705 1.668 1.062 2.906 1.062h.004l.885-.012-1.827.756 1.387.667c.504.245 1.101.534 1.71.755l-.173.471.478.218c.043.02.962.428 2.49.515 0 0 .368.017.572.017.203 0 .567-.018.567-.018 1.52-.09 2.431-.495 2.474-.515l.48-.218-.176-.471c.626-.228 1.246-.529 1.729-.764l1.361-.658-1.82-.755.887.012c1.24 0 2.22-.358 2.908-1.064.197-.202.365-.428.505-.678.282.116.584.175.89.173.4 0 .729-.088.738-.09l1.082-.285-.472-.987c-.011-.026-.269-.644.03-1.532a6.86 6.86 0 0 0 .193-.682c.203.044.414.066.634.067a2.357 2.357 0 0 0 2.012-1.091l.529-.915-.978-.4c-.679-.28-.987-.93-1.124-1.51 1.263-.11 1.939-1.17 2.147-1.812z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18.136 5.689c-.589-.326-1.353-.511-2.133-.511-.776 0-1.54.185-2.13.511a5.413 5.413 0 0 0-.233-.625l.223.026.233.024.1-.211.294-.625.545.281.211.106.169-.165.587-.58.59.58.17.165.21-.106.542-.281.298.625.1.211.233-.024.223-.026a5.248 5.248 0 0 0-.232.625zm-2.134.777c-1.035 0-1.81.338-1.979.735l1.98.777 1.98-.777c-.168-.397-.944-.734-1.98-.735h-.001zm.02 20.58h-.038c-.628.003-1.492-.124-1.906-.245l-.502 1.347c.33.117 1.448.34 2.43.34.977 0 2.094-.223 2.424-.34l-.5-1.347c-.417.12-1.28.248-1.906.244h-.001zm2.1-.67c.485-.147 1.316-.462 1.688-.671l-.247.81.842.279c-.6.293-1.228.525-1.876.695l-.406-1.113zm-5.926-.671.25.81-.844.279c.508.255 1.129.492 1.875.695l.406-1.113c-.483-.147-1.316-.462-1.687-.671zM27.91 12.407a.96.96 0 0 0 .307.05c.441 0 .867-.284 1.014-.61 0 0-.809-.048-1.679-.927-.277-.284-.57-.37-.822-.37-.39 0-.684.205-.684.205.568.3.892.7 1.164 1.035.231.285.425.524.7.617zm-23.818-.001a.91.91 0 0 1-.305.05c-.44 0-.868-.284-1.013-.608 0 0 .808-.05 1.677-.928.279-.285.57-.37.824-.37.388 0 .683.205.683.205-.566.3-.89.698-1.162 1.032-.233.286-.427.526-.704.619z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="m28.248 16.038-.052-.002c-.505-.017-.764-.21-.764-.21s-.198 2.664 1.8 3.49c0 0-.362.628-1.196.628h-.01c-1.003-.005-1.405-.612-1.405-.612s.058.79-.303 1.857c-.434 1.286.004 2.205.004 2.205s-.234.063-.503.063c-.103 0-.211-.01-.31-.037-.838-.198-1.046-.956-1.046-.956s.077 2.56-2.921 2.56h-.022s.264-.358.341-1.387c.142-1.898 1.434-2.16 1.434-2.16s-.689-.085-.989-.35c-.466-.423-.433-.91-.433-.91 1.055-.014 1.744-.371 2.272-.977.57-.657.665-1.364.665-1.364s-.568.511-1.665.511c-.096 0-.199-.004-.305-.015-.52-.041-.878-.37-.878-.37 1.142-.728 1.942-2 1.233-3.912-.57-1.536-1.937-2.68-3.313-3.543-.458-.285-.713-.602-.713-.874 0-.393.345-.552.697-.716.223-.104.45-.21.594-.376.435-.5.163-1.311-.213-1.8 0 0 .126-.026.326-.026.621-.005 1.217.24 1.645.68.747.77.438 1.61.438 1.61l.2.038c.112.024.222.03.335.036l.028.001.081.001c1.087 0 1.572-1.13 1.572-1.13s1.157 1.414-.546 2.523c-.292.189-.422.365-.387.553l.026.123.122.02c1.18.32 1.804 1.11 2.524 2.023l.094.12a3.997 3.997 0 0 0 2.997 1.51h.021s-.373 1.175-1.474 1.175zm-2.104.943c.125.38.637 1.44 1.45 1.84 0 0-1.022-.614-1.48-3.004v.019c-.304-2.433-2.079-4.19-4.055-5.258a15.74 15.74 0 0 0-.514-.26c.6.094 1.57.104 2.317-.54 0 0-1.145.837-3.486.076.188.122.427.258.7.413.67.38 1.541.876 2.358 1.555 2.877 2.516.82 4.969.82 4.969 1.032-1.074 1.076-2.224.771-3.164.545.903.893 1.997.84 3.346-.08 1.933-1.148 3.606-2.272 4.949-.54.652-.66 1.453-.66 1.453s.218-.707.842-1.434c1.205-1.403 2.233-2.86 2.369-4.96zM8.232 21.94c-1.205-1.403-2.234-2.86-2.37-4.96-.125.381-.637 1.44-1.45 1.839 0 0 1.022-.613 1.481-3.002v.018c.304-2.434 2.079-4.19 4.054-5.258.152-.082.298-.153.437-.22l.078-.04c-.6.094-1.57.105-2.317-.54 0 0 1.144.836 3.486.076-.188.122-.429.258-.703.414-.668.38-1.538.875-2.355 1.554-2.877 2.515-.82 4.97-.82 4.97-1.035-1.076-1.075-2.226-.771-3.164-.545.902-.893 1.995-.837 3.345.077 1.933 1.145 3.605 2.267 4.95.542.651.665 1.451.665 1.451s-.221-.706-.846-1.434zm1.47-.816c-.3.267-.99.353-.99.353s1.293.261 1.435 2.16c.078 1.028.339 1.386.339 1.386h-.02c-2.999 0-2.923-2.56-2.923-2.56s-.209.758-1.045.955c-.1.028-.206.038-.31.038-.27 0-.502-.063-.502-.063s.436-.919.002-2.205c-.36-1.067-.301-1.857-.301-1.857s-.403.607-1.405.613h-.01c-.833 0-1.197-.63-1.197-.63 1.997-.825 1.8-3.49 1.8-3.49s-.259.193-.765.212h-.052c-1.102 0-1.475-1.173-1.475-1.173h.022c.204 0 1.84-.048 2.996-1.511l.096-.122c.72-.912 1.343-1.701 2.522-2.02l.123-.021.026-.123c.035-.188-.094-.364-.387-.553-1.7-1.109-.546-2.523-.546-2.523s.484 1.13 1.573 1.13h.08l.029-.002a2.11 2.11 0 0 0 .334-.036l.2-.037s-.31-.84.438-1.61a2.269 2.269 0 0 1 1.645-.68c.2 0 .325.024.325.024-.374.49-.646 1.301-.213 1.802.146.166.372.271.594.374.353.164.696.324.696.717 0 .272-.254.59-.712.874-1.377.862-2.743 2.008-3.312 3.543-.71 1.914.091 3.184 1.235 3.913 0 0-.36.328-.88.37-.105.01-.208.014-.307.014-1.095 0-1.661-.51-1.661-.51s.094.706.66 1.363c.53.605 1.22.963 2.275.977 0 0 .034.487-.433.909zm5.624-9.075h1.413v.483c-.166-.202-.49-.16-.49-.16v.694s.013.342.133.491h-.699c.123-.149.133-.49.133-.49v-.697s-.322-.04-.49.161v-.482zm-1.395.24a3.61 3.61 0 0 0-.171-.194 1.794 1.794 0 0 0-.828-.488l.155-.09h.008l.61-.35.624-.357 1.67.906.004-.004.004.004 1.67-.906.625.357.608.35h.01l.152.09a1.798 1.798 0 0 0-.826.49l-.024.024a3.411 3.411 0 0 0-.311.393l-.022.033c-.05.075-.099.155-.147.237-.434.742-1.125 1.188-1.74 1.188-.614-.002-1.304-.445-1.737-1.188l-.006-.01a5.816 5.816 0 0 0-.14-.224l-.008-.013a3.661 3.661 0 0 0-.171-.236l-.009-.011z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M15.858 11.114zm0 0V8.29l-1.807-.61.477 2.737 1.33.697zM15.47 9.44v-.455l-.822-.344s.007.264.377.55c.196.154.319.195.35.206a.049.049 0 0 1 .008.003l.087.04zm1.065-.455.822-.344s-.008.264-.378.55c-.201.159-.326.198-.352.206l-.005.002-.087.04v-.454zm1.417-1.303-.474 2.737-1.33.697V8.29l1.804-.61zm-4.65 9.982a1.6 1.6 0 0 0 .499.076l.015-.05a.893.893 0 0 0 .027-.098c.026-.148.04-.298.043-.448a.63.63 0 0 1-.237-.25c-.068-.14-.162-.206-.303-.206-.18 0-.376.11-.46.16-.066.39.222.745.417.816zm3.051-.548c.19-.185.674-.656.945-.95.087.109.192.202.31.277-.058.303.004.617.174.877-.274.202-.98.715-1.238.893l-2.469-.441.017-.066c.043-.165.066-.335.068-.506l2.075.033.04-.04.078-.077z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.234 14.368c.41-.041.87-.216 1.347-.688h3.12c-.135.358-.248.745-.248 1.13l.002 2.487c-.523-.087-.584-.647-.586-.671l-.01-.114-.112-.01a.795.795 0 0 1-.505-.24c-.256-.255-.256-.668-.256-.672 0 .003-.004.01-.01.021-.048.089-.235.437.052.813.135.178.332.288.587.331.06.31.292.748.84.815v1.217h-1.54c-.71-.394-.41-1.086-.396-1.114l.06-.133-.136-.05c-.77-.285-.557-1.048-.547-1.081l.03-.111-.103-.05c-.636-.293-.55-1.08-.542-1.115-.194.158-.266.48-.13.794-.07.08-.162.174-.263.278l-.015.015a.858.858 0 0 1-.678-.795l-.002-.092-.087-.034c-.257-.095-.432-.237-.52-.426a.835.835 0 0 1-.036-.54c.148.031.298.047.449.047h.01c.075 0 .15-.004.225-.012zm-2.84 2.036.042-1.584h-.001l.358-.376.224.468-.442 1.519-.181-.027zm.998 4.277a.09.09 0 0 1-.064-.03.087.087 0 0 1-.023-.065.088.088 0 0 1 .031-.062.092.092 0 0 1 .066-.022.09.09 0 0 1 .057.157.093.093 0 0 1-.066.023zm3.961 1.407a.175.175 0 0 0-.044-.005c-.088 0-.127.078-.127.078.06.16.075.274.089.378a.938.938 0 0 0 .1.354c.086.165.23.304.316.387l.038.037s-.02.147-.041.256l-.193.997a4.101 4.101 0 0 1-.386.03l.204-.958c.029-.138-.139-.23-.362-.353-.235-.13-.532-.292-.726-.579-.186.207-.534.27-.884.27-.32 0-.641-.052-.835-.09a.954.954 0 0 0-.143-.013.309.309 0 0 0-.285.152l-.055.094-1.047-.245-.26.43c-.036.07-.04.127.02.192l.07.077c-.048.152-.267.382-.267.382l-.155-.194c-.122-.137-.103-.388.025-.62l.416-.698.886.128-.137-.313c-.13-.288-.03-.63.05-.914.036-.123.068-.235.077-.327-.01.09-.094.112-.193.112-.048 0-.099-.005-.146-.01-.04-.004-.079-.007-.11-.007-.026 0-.048.002-.06.011l-.24.146-.19-.167c-.022-.032-.03-.107.026-.164l.438-.49-.517-.602.725.363.221-.267c.06.059.035.214.035.214.226.007.861.355.895 1.171v.08l.018.027c.046.061.17.218.326.234l1.003.098h.005c.042 0 .1-.019.172-.042.115-.037.264-.086.437-.086.18.001.355.054.504.152a.45.45 0 0 1 .24-.079c.011-.002.024-.002.034-.002.378 0 .57.285.764.575a20.564 20.564 0 0 1 .539.801c-.09.106-.174.165-.313.165a.67.67 0 0 1-.13-.012c-.277-.05-.417-.399-.54-.7-.09-.223-.17-.42-.287-.454z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.341 23.122c-.03.142-.377.343-.377.343v.001l-.076-.232c-.098-.325-.024-.702.18-.915l.562-.482.598.178a.953.953 0 0 0 .102.466l-.625-.17-.375.365c-.064.062-.068.176-.035.283l.046.163zm4.42 2.63c-.135 0-.26.002-.371.01l.293-1.288c.031-.12-.065-.264-.16-.407-.045-.069-.09-.137-.122-.202.227.19.46.364.7.522-.019.04-.34 1.365-.34 1.365z"
        fill="#fff"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18.476 18.787h-6.923V14.81c0-.385-.113-.772-.247-1.13h3.12c.297.293.587.476.863.577-.064.24-.046.495.051.724.109.236.306.417.59.537.046.416.326.772.726.92-.223.224-.441.436-.53.522l-2.07-.034a.375.375 0 0 1-.171-.165l-.007-.01.338.053.022.001a.133.133 0 0 0 .133-.111.135.135 0 0 0-.112-.155l-.416-.065.46-1.586-.436-.915-.7.737-.043 1.648-.47-.074a.135.135 0 1 0-.043.267l.198.03a1.432 1.432 0 0 0-.124.076l-.039.028-.011.048c-.114.463.144.902.424 1.099l-.01.058a.266.266 0 0 0 .52.104c.106.012.2.015.267.015h.054l2.717.489.046-.032c.216-.15 1.042-.748 1.313-.947.078.068.165.125.259.17-.09.293-.094.742.251 1.098zm-6.925.269h8.902l.002 3.332c0 1.104-.653 1.876-1.678 2.127l.172-.892.008-.046a2.98 2.98 0 0 0 .019-.12.95.95 0 0 0 .333.066.655.655 0 0 0 .517-.255l.132-.152-.107-.168c-.172-.273-.351-.54-.538-.804-.21-.312-.47-.7-.994-.7h-.047a.76.76 0 0 0-.22.046 1.199 1.199 0 0 0-.512-.117 1.61 1.61 0 0 0-.547.109c-.024.007-.045.014-.064.016l-.979-.094c-.012-.002-.052-.027-.1-.084v-.005l.21-.084c-.06-.703-.737-1.134-1.114-1.281a.39.39 0 0 0-.11-.197l-.21-.2-.185.222-.092.111-1.371-.56.893 1.115-.353.53c-.128.137.013.273.013.273l.364.25.377-.14.023.002.015.002a1.659 1.659 0 0 0-.034.198c-.01.061-.017.119-.024.146l-.654-.129-.687.386a.809.809 0 0 0-.271.979l.075.167.109.233.24-.099a.016.016 0 0 0 .01-.003c-.087.275-.052.536.103.708l.145.181.196.245.212-.228c.062-.062.267-.288.33-.482l.046-.15-.105-.114-.016-.02.116-.193.854.2.193.045.102-.168.056-.091c.01-.02.013-.023.052-.023.031 0 .062.004.093.01.29.058.587.088.883.091.257 0 .41-.01.593-.07l.474.538-.281.863-.014.052c-.532.044-.79.16-1.103.47-.454-.449-.777-.496-1.998-.496-1.463 0-2.454-.853-2.454-2.216v-3.332z"
        fill="#FFE52B"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18.343 6.213c-.461-.365-1.296-.71-2.34-.71-1.044 0-1.876.345-2.34.711 0 0-.137-.82-.605-1.545l.84.094.44-.93.847.434.818-.805.819.805.845-.434.44.93.84-.094c-.467.724-.604 1.544-.604 1.544zm-4.48-1.124.232.025.101-.211.293-.625.546.28.211.108.757-.747.589.581.17.166.21-.108.542-.28.298.625.099.21.233-.023.223-.026c-.09.203-.168.412-.232.625-.588-.326-1.352-.512-2.132-.512-.777 0-1.54.186-2.131.512a5.353 5.353 0 0 0-.232-.625l.222.026zm6.067 21.26.512.196.57.212-.177.086c-.633.307-1.454.706-2.21.912l.196.532s-1.051.477-2.805.48v.003h-.025v-.002c-1.752-.004-2.803-.481-2.803-.481l.196-.532c-.75-.204-1.56-.597-2.193-.902l-.197-.096.57-.212.515-.195-.145-.528-.153-.575s.908.491 2.188.859c.363.104.639.151.639.151v.392s.683.118 1.377.118h.038c.692 0 1.377-.118 1.377-.118v-.391s.275-.047.638-.151c1.281-.369 2.189-.86 2.189-.86l-.155.575-.142.528zm-8.328.445.844-.28-.25-.81c.373.21 1.206.525 1.689.673l-.407 1.113a10.26 10.26 0 0 1-1.876-.696zm6.52-.418.407 1.114a10.26 10.26 0 0 0 1.875-.696l-.841-.28.248-.81c-.372.21-1.204.525-1.688.672zm-4.546 1.773c.331.116 1.449.34 2.429.34.977 0 2.097-.224 2.426-.34l-.5-1.349c-.418.122-1.28.25-1.908.245h-.04c-.626.004-1.49-.123-1.906-.245l-.5 1.349zm15.656-8.834s-.363.63-1.197.63h-.01c-1.001-.006-1.405-.613-1.405-.613s.058.79-.303 1.857c-.434 1.286.004 2.205.004 2.205s-.234.063-.503.063a1.206 1.206 0 0 1-.311-.038c-.836-.197-1.045-.954-1.045-.954s.077 2.558-2.92 2.558h-.024s.265-.357.343-1.386c.142-1.898 1.434-2.16 1.434-2.16s-.69-.085-.988-.352c-.468-.421-.435-.908-.435-.908 1.055-.014 1.746-.372 2.272-.977.34-.39.57-.86.664-1.364 0 0-.567.511-1.663.511-.097 0-.2-.004-.306-.014a1.62 1.62 0 0 1-.877-.37c1.142-.73 1.942-2 1.232-3.913-.569-1.535-1.935-2.68-3.312-3.543-.458-.285-.713-.602-.713-.874 0-.393.344-.553.697-.716.222-.104.449-.21.594-.376.434-.5.162-1.311-.213-1.8 0 0 .125-.026.326-.026.395 0 1.08.099 1.645.68.748.77.437 1.61.437 1.61l.2.038c.112.024.222.03.336.036l.027.001.081.001c1.087 0 1.573-1.13 1.573-1.13s1.155 1.414-.546 2.522c-.293.19-.422.366-.388.553l.026.124.121.02c1.18.32 1.802 1.108 2.52 2.018l.1.125a3.997 3.997 0 0 0 2.996 1.511h.022s-.374 1.174-1.475 1.174l-.052-.001c-.505-.02-.765-.211-.765-.211s-.197 2.664 1.801 3.49zm.836-4.344c-.018.059-.47 1.425-1.82 1.425l-.063-.002a2.29 2.29 0 0 1-.385-.045c.054.745.329 2.123 1.57 2.636l.38.156-.204.355-.003.005c-.046.072-.508.802-1.519.802a2.334 2.334 0 0 1-1.079-.252 6.317 6.317 0 0 1-.285 1.254c-.375 1.107-.034 1.888-.014 1.934l.186.391-.42.112-.015.003c-.067.015-.302.069-.579.069-.422 0-.83-.15-1.15-.42-.114.35-.31.746-.651 1.096-.578.592-1.411.891-2.5.891l-.659-.01.365-.552v-.001c.013-.021.215-.352.279-1.207.077-1.053.477-1.668.872-2.02a1.289 1.289 0 0 1-.31-.2c-.58-.52-.556-1.13-.553-1.197l.026-.33.33-.004c.887-.015 1.504-.279 2.006-.856.117-.137.211-.272.288-.405a3.48 3.48 0 0 1-1.016.147c-.106 0-.219-.007-.337-.014a1.984 1.984 0 0 1-1.09-.463l-.345-.316.394-.252c.878-.56 1.781-1.623 1.088-3.487-.447-1.211-1.484-2.31-3.166-3.36-.567-.359-.88-.78-.88-1.18 0-.621.522-.867.904-1.04l.036-.018c.175-.083.35-.167.439-.269.295-.34.046-.994-.229-1.348l-.35-.459.567-.113a2.682 2.682 0 0 1 .397-.028c.425 0 1.24.101 1.904.786.553.57.624 1.175.595 1.568l.165.009h.063c.826 0 1.221-.87 1.24-.912l.235-.55.376.463c.024.028.577.716.444 1.578-.09.573-.451 1.066-1.072 1.472-.067.044-.116.08-.15.11 1.165.377 1.819 1.203 2.506 2.072l.01.012.1.124a3.627 3.627 0 0 0 2.723 1.374h.002l.506-.015-.152.481z"
        fill="#1A1918"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="m10.784 24.818.364.554-.659.008c-1.087 0-1.92-.298-2.5-.89a2.81 2.81 0 0 1-.651-1.097c-.32.272-.727.421-1.15.42-.294 0-.545-.06-.589-.07l-.004-.001-.422-.112.187-.39v-.001c.02-.046.36-.827-.013-1.934a6.286 6.286 0 0 1-.286-1.254 2.33 2.33 0 0 1-1.076.252c-1.039 0-1.5-.768-1.523-.806l-.205-.356.378-.156c1.241-.513 1.517-1.89 1.573-2.636-.126.026-.255.04-.385.046l-.065.001c-1.35 0-1.8-1.366-1.819-1.425l-.155-.481.51.015a3.623 3.623 0 0 0 2.724-1.375l.1-.123.005-.006c.688-.871 1.342-1.699 2.51-2.077a1.01 1.01 0 0 0-.148-.11c-.622-.407-.982-.9-1.072-1.473-.135-.862.419-1.55.44-1.577l.38-.464.233.55c.02.043.414.912 1.243.912h.06l.164-.01c-.028-.391.045-.998.598-1.568.665-.684 1.478-.786 1.903-.786a2.5 2.5 0 0 1 .395.03l.571.111-.353.46c-.275.354-.524 1.007-.227 1.348.088.103.265.187.441.27l.033.016c.382.175.903.42.903 1.04 0 .403-.311.822-.879 1.18-1.684 1.052-2.719 2.15-3.167 3.361-.692 1.864.209 2.927 1.09 3.487l.393.252-.344.315a1.993 1.993 0 0 1-1.093.464c-.118.008-.229.014-.336.014a3.476 3.476 0 0 1-1.014-.147c.083.143.179.279.287.405.501.577 1.12.84 2.005.856l.333.005.022.33c.004.066.029.676-.552 1.195a1.29 1.29 0 0 1-.31.201c.396.353.796.967.875 2.02.065.855.264 1.186.277 1.207zm-.32.205c-2.997 0-2.92-2.559-2.92-2.559s-.21.758-1.046.956a1.237 1.237 0 0 1-.31.037c-.27 0-.502-.064-.502-.064s.436-.919.002-2.205c-.36-1.066-.3-1.857-.3-1.857s-.404.607-1.406.614h-.01c-.833 0-1.197-.63-1.197-.63 1.996-.826 1.8-3.49 1.8-3.49s-.258.193-.765.211h-.052c-1.103 0-1.475-1.172-1.475-1.172h.022c.203 0 1.838-.048 2.996-1.512l.098-.124c.72-.91 1.341-1.699 2.52-2.018l.123-.022.027-.123c.034-.186-.095-.363-.387-.552C5.98 9.405 7.135 7.99 7.135 7.99S7.62 9.12 8.71 9.12h.079l.029-.002c.113-.006.224-.011.334-.035l.2-.038s-.312-.84.44-1.61a2.27 2.27 0 0 1 1.968-.655c-.374.49-.646 1.3-.212 1.801.145.166.37.271.593.375.353.164.696.324.696.717 0 .272-.254.59-.712.873-1.377.863-2.743 2.009-3.312 3.543-.71 1.914.091 3.184 1.235 3.914 0 0-.36.327-.88.369-.106.01-.208.015-.307.015-1.095 0-1.66-.511-1.66-.511-.001 0 .093.706.66 1.363.53.607 1.22.963 2.274.978 0 0 .034.486-.433.909-.3.265-.989.351-.989.351s1.293.262 1.435 2.16c.078 1.028.339 1.386.339 1.386h-.021zm15.65-9.2v-.006h-.002l.002.005zm0 .013v-.014c.46 2.386 1.48 2.998 1.48 2.998-.812-.4-1.326-1.458-1.45-1.84-.135 2.1-1.165 3.558-2.37 4.96-.623.728-.841 1.435-.841 1.435s.12-.801.66-1.454c1.123-1.343 2.192-3.015 2.27-4.948.055-1.35-.293-2.444-.838-3.346.305.94.261 2.09-.772 3.163 0 0 2.058-2.453-.819-4.968-.818-.68-1.69-1.177-2.36-1.557-.272-.155-.511-.29-.699-.411 2.343.76 3.487-.077 3.487-.077-.748.646-1.717.635-2.318.542.174.082.345.169.515.258 1.976 1.069 3.75 2.825 4.054 5.26zm-.238-4.764c.503.267.798.625 1.055.943l.004.005c.25.308.49.602.863.726.134.045.276.067.42.067.562 0 1.128-.343 1.343-.818l.216-.476-.523-.031c-.024 0-.696-.062-1.442-.821-.308-.313-.68-.476-1.08-.476-.465 0-.815.22-.884.263l-.008.005-.48.337.516.276zm.856-.522c.252 0 .545.085.822.37.87.879 1.678.928 1.678.928-.147.324-.573.609-1.014.609a.932.932 0 0 1-.306-.051c-.276-.093-.47-.332-.701-.617-.272-.335-.596-.733-1.163-1.034 0 0 .293-.206.684-.206z"
        fill="#1A1918"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M15.026 9.189c.198.157.323.197.35.206l.006.002.088.041v-.455l-.822-.343s.008.263.377.549h.001zm-8.882 7.784c-.056-1.35.293-2.443.837-3.346-.303.94-.262 2.09.772 3.163 0 0-2.058-2.453.82-4.968.819-.68 1.691-1.177 2.36-1.557.272-.155.51-.29.698-.411-2.342.76-3.486-.076-3.486-.076.747.644 1.716.634 2.317.54l-.044.022c-.15.073-.305.149-.47.238-1.977 1.068-3.751 2.825-4.055 5.258v-.02c-.459 2.391-1.48 3.004-1.48 3.004.812-.399 1.324-1.459 1.449-1.84.135 2.1 1.165 3.558 2.369 4.96.625.728.844 1.435.844 1.435s-.122-.8-.664-1.453c-1.122-1.343-2.188-3.016-2.267-4.949zm-1.936-4.227a1.298 1.298 0 0 1-.42.067c-.562 0-1.127-.343-1.343-.818l-.214-.476.523-.031c.023 0 .694-.062 1.442-.822.306-.311.679-.475 1.08-.475.472 0 .824.225.885.264l.006.004.48.336-.518.277c-.498.264-.788.619-1.044.933l-.008.01-.014.017c-.249.303-.485.592-.855.714zm1.068-2.196c-.253 0-.545.085-.824.37-.869.878-1.677.927-1.677.927.145.324.573.608 1.013.608a.91.91 0 0 0 .305-.049c.276-.093.47-.332.703-.618.272-.335.596-.733 1.163-1.034 0 0-.295-.204-.683-.204zm10.05 1.983v-.483h1.413v.482c-.166-.202-.49-.161-.49-.161v.696s.013.342.133.49h-.699c.123-.148.133-.49.133-.49v-.695s-.322-.042-.49.16zm2.032-3.893s-.008.263-.38.549h.002c-.201.158-.326.198-.352.207l-.005.001-.087.041v-.455l.822-.343z"
        fill="#1A1918"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.007 6.03c1.287 0 2.453.62 2.453 1.309l-.025.17-.514 2.935.514.299 1.338.775h-.005s.3.154.437.248c.512.353.619.865.323 1.077-.073-.418-.405-.855-1.026-.855-.448 0-.789.228-1.067.575-.07.087-.137.18-.2.28a5.418 5.418 0 0 1-.232.344h3.44c-.253.506-.493 1.042-.493 1.623v7.579c0 1.833-1.415 2.708-2.949 2.708h-.25c-.963-.004-1.144-.004-1.746.595-.604-.6-.787-.599-1.75-.595h-.248c-1.534 0-2.95-.875-2.95-2.71V14.81c0-.581-.241-1.117-.494-1.623h3.44a5.418 5.418 0 0 1-.231-.344c-.063-.1-.13-.193-.203-.28-.274-.345-.616-.575-1.064-.575-.622 0-.954.437-1.027.855-.295-.212-.186-.724.322-1.077.139-.093.44-.247.44-.247h-.005l1.335-.776.516-.299-.514-2.935-.025-.17c0-.69 1.166-1.309 2.453-1.309h.007zm-1.984 1.171 1.98.778 1.98-.778c-.168-.397-.945-.735-1.98-.736-1.035.001-1.811.338-1.98.736zm2.125 3.914 1.33-.697.476-2.738-1.806.61v2.825zm2.154.051.61.351h.007l.153.09a1.79 1.79 0 0 0-.826.49l-.025.024a2.919 2.919 0 0 0-.148.17l-.029.036c-.047.06-.091.123-.133.187l-.023.033a4.38 4.38 0 0 0-.147.237c-.433.743-1.124 1.186-1.738 1.187-.615 0-1.307-.445-1.738-1.187a4.997 4.997 0 0 0-.145-.234l-.03-.04a4.72 4.72 0 0 0-.148-.208l-.011-.013a3.227 3.227 0 0 0-.157-.179 1.793 1.793 0 0 0-.841-.504l.155-.088h.007l.61-.35.625-.358 1.67.905.003-.003.005.003 1.669-.905.625.356zm2.151 3.644c0-.385.113-.772.249-1.13h-3.12c-.479.471-.937.647-1.348.687a2.214 2.214 0 0 1-.226.013h-.01c-.15-.001-.3-.017-.448-.048a.838.838 0 0 0 .037.54c.087.19.263.332.52.426l.086.034.002.093c.018.384.295.71.678.796l.017-.018c.1-.104.191-.197.26-.275-.134-.316-.064-.637.131-.795-.007.033-.093.822.541 1.115l.105.05-.031.111c-.01.033-.222.796.547 1.08l.136.051-.06.132c-.014.03-.314.721.396 1.114h1.54V17.57c-.547-.066-.78-.504-.84-.814-.254-.044-.452-.153-.587-.331-.286-.377-.1-.725-.052-.813l.01-.021c0 .005 0 .417.257.672a.799.799 0 0 0 .504.24l.112.01.01.113c.002.025.064.584.586.672l-.002-2.487zm-1.675 9.704.172-.89.027-.167a.96.96 0 0 0 .333.067.655.655 0 0 0 .518-.256l.131-.152-.107-.168a15.94 15.94 0 0 0-.433-.65 3.59 3.59 0 0 1-.105-.154c-.208-.312-.47-.701-.994-.701h-.046a.773.773 0 0 0-.22.046 1.202 1.202 0 0 0-.513-.116c-.216 0-.398.06-.52.1a1.299 1.299 0 0 0-.039.012.565.565 0 0 1-.051.014l-.98-.096c-.012-.003-.052-.025-.1-.083v-.005l.21-.085c-.058-.702-.736-1.134-1.114-1.28a.394.394 0 0 0-.11-.197l-.21-.2-.185.221-.09.112-1.373-.56.893 1.115-.352.53c-.129.137.013.273.013.273l.364.25.378-.14a.14.14 0 0 1 .02.002l.016.002a1.658 1.658 0 0 0-.034.198c-.009.06-.017.118-.024.145l-.654-.127-.687.385a.808.808 0 0 0-.27.98l.075.165.11.234.24-.098.009-.005c-.087.274-.053.537.102.708l.145.183.196.244.213-.228c.062-.062.266-.289.329-.483l.046-.149-.104-.113-.018-.021.117-.193.855.2.192.045.102-.169.056-.09c.01-.02.014-.023.052-.023.031 0 .061.003.094.01.322.06.62.09.884.09.255 0 .408-.01.59-.069l.475.538-.28.862-.013.053c-.532.043-.792.159-1.104.47-.455-.45-.777-.496-1.998-.496-1.463 0-2.454-.853-2.454-2.216v-3.334h8.902l.002 3.334c0 1.104-.652 1.875-1.68 2.127zm-5.437-1.768-.046-.115c-.032-.075-.028-.157.036-.201l.374-.258.625.12a.522.522 0 0 1-.102-.329l-.598-.126-.563.341a.542.542 0 0 0-.179.648l.076.164s.346-.143.377-.244zm5.344.827-.193.996a3.787 3.787 0 0 1-.386.031l.203-.957c.03-.139-.138-.23-.361-.354-.235-.129-.532-.292-.727-.579-.184.206-.534.27-.884.27a4.57 4.57 0 0 1-.834-.09.929.929 0 0 0-.143-.013.308.308 0 0 0-.286.151l-.055.095-1.047-.245-.26.429c-.036.07-.039.128.02.193l.07.077c-.047.151-.265.381-.265.381l-.156-.194c-.123-.136-.104-.388.025-.62l.415-.697.887.128-.138-.313c-.13-.29-.03-.634.052-.918.035-.122.067-.233.076-.324-.01.091-.096.112-.194.112-.047 0-.098-.005-.145-.01-.041-.003-.08-.007-.11-.007-.026 0-.048.003-.06.012l-.241.145-.189-.167c-.023-.032-.03-.107.025-.163l.439-.49-.518-.602.726.363.22-.267c.061.06.035.214.035.214.227.005.861.355.895 1.171.002.025.002.052.002.08l.017.026c.044.062.17.219.326.234l1.002.099h.005a.66.66 0 0 0 .172-.043c.115-.037.265-.086.438-.086.153 0 .322.039.503.152 0 0 .093-.072.24-.078.011-.002.024-.002.035-.002.379 0 .571.287.766.578.037.055.073.11.111.162.182.256.425.636.425.636-.09.106-.173.165-.312.165a.649.649 0 0 1-.13-.013c-.277-.05-.418-.398-.54-.7-.09-.223-.17-.42-.287-.453a.16.16 0 0 0-.044-.006c-.088 0-.127.079-.127.079.06.159.075.273.088.377.015.116.029.218.1.355.085.162.227.3.313.385l.041.04s-.02.146-.04.255zm-1.296 1.041c.124-.005.247-.007.371-.007.11-.323.224-.645.34-.967a7.935 7.935 0 0 1-.699-.367c.031.046.077.095.123.143.095.1.19.202.16.287l-.295.911zm-3.995-8.211v-.001l.18.028.442-1.519-.224-.467-.357.375-.041 1.583zm.493.74a.634.634 0 0 1-.237-.25c-.066-.14-.162-.206-.303-.206-.181 0-.376.109-.46.16-.067.39.223.744.417.816.16.052.33.077.498.076a1.19 1.19 0 0 0 .042-.149c.03-.157.042-.334.043-.448zm3.896.175c-.275.201-.981.715-1.238.893l-2.469-.441.017-.066c.033-.127.065-.302.067-.506l2.076.033.039-.04.053-.052c.169-.164.687-.666.971-.975.08.1.18.194.31.277-.045.243-.025.587.174.877zm-2.494-3.061c-.276-.1-.566-.284-.863-.577h-3.12c.134.358.247.745.247 1.13v3.977h6.924c-.346-.356-.34-.806-.253-1.098a1.15 1.15 0 0 1-.259-.169c-.27.198-1.095.796-1.312.947l-.046.03-2.716-.488h-.056c-.065 0-.16-.003-.265-.015a.265.265 0 0 1-.473.094.258.258 0 0 1-.048-.198l.01-.058c-.279-.197-.538-.636-.424-1.099l.011-.048.04-.029c.04-.027.08-.052.123-.075l-.197-.03a.136.136 0 0 1-.113-.155.134.134 0 0 1 .155-.112l.47.074.043-1.648.7-.737.438.915-.462 1.586.415.065a.135.135 0 0 1 .113.154.133.133 0 0 1-.133.112h-.021l-.339-.055.007.012a.37.37 0 0 0 .171.165l2.071.032c.088-.086.306-.297.53-.521a1.114 1.114 0 0 1-.727-.92c-.285-.12-.481-.301-.59-.536a1.126 1.126 0 0 1-.051-.725zm-1.238-6.578 1.808.61v2.825l-1.33-.697-.478-2.737z"
        fill="#1A1918"
      />
    </svg>
  )
})
