import React, { forwardRef } from 'react'
import { IconProps } from '../types'
import './VneshprombankWhite.css'
export const VneshprombankWhiteIcon = forwardRef<HTMLElement, IconProps<24 | 32>>((props, ref) => {
  const { className, size = 24, ...otherProps } = props
  return (
    <i
      {...otherProps}
      className={'VneshprombankWhiteIcon' + (className ? ' ' + className : '')}
      ref={ref}
      data-size={size}
    />
  )
})
