/* eslint-disable react-hooks/rules-of-hooks */
const { resolve } = require('path');
const { useCleanUpPlugin } = require('@bem-react/pack/lib/plugins/CleanUpPlugin');
const { useCopyAssetsPlugin } = require('@bem-react/pack/lib/plugins/CopyAssetsPlugin');
const { useCssPlugin } = require('@bem-react/pack/lib/plugins/CssPlugin');
const { useTypeScriptPlugin } = require('@bem-react/pack/lib/plugins/TypeScriptPlugin');
const { usePackageJsonPlugin } = require('@bem-react/pack/lib/plugins/PackageJsonPlugin');

const IS_CI = process.env.TRENDBOX_CI;

/**
 * @type {import('@bem-react/pack/lib/interfaces').Config}
 */
module.exports = {
  silent: IS_CI,

  context: resolve(__dirname, '..'),

  output: './dist',

  plugins: [
    useCleanUpPlugin(['./dist']),

    useTypeScriptPlugin({
      configPath: './tsconfig.prod.json',
      onCreateSideEffects: () => ['*.css'],
    }),

    useCssPlugin({
      context: './src',
      src: './**/*.css',
      output: ['./dist', './dist/esm'],
      postcssConfigPath: './.config/postcss/components/postcss.config.js',
    }),

    useCopyAssetsPlugin([
      {
        context: './src',
        src: './**/*.{svg,png,md,json,yml}',
        output: ['./dist', './dist/esm'],
      },
      {
        src: ['./README.md'],
      },
    ]),

    usePackageJsonPlugin({
      scripts: {},
      module: './esm/index.js',
    }),
  ],
};
