const path = require('path');

const config = require('@yandex-int/frontend-hermione-config/overrides/storybook.config');

function getTestName(test) {
  const listTitles = [];

  for (let currentSuite = test; currentSuite; currentSuite = currentSuite.parent) {
    const { title } = currentSuite;

    if (!title) {
      continue;
    }

    const titles = title
      .replace(/[^\s\da-zа-яё]/gi, '') // оставляем пробельный символ, 0-9, a-z, а-я
      .split(/\s+/)
      .filter(Boolean);

    listTitles.unshift(...titles);
  }

  if (listTitles.length === 0) {
    throw new Error('Invalid test title');
  }

  return listTitles
    .map((title) => title.slice(0, 1).toUpperCase() + title.slice(1).toLowerCase())
    .join('');
}

module.exports = {
  ...config,

  system: {
    fileExtensions: ['.ts'],
  },

  sets: {
    desktop: {
      files: ['src/**/*.hermione.ts'],
      browsers: ['linux-chrome', 'linux-firefox'],
    },
    touch: {
      files: ['src/components/Card/__tests__/Card.hermione.ts'],
      browsers: ['chrome-grid-320'],
    },
  },
  screenshotsDir(test) {
    return path.join(path.dirname(test.file), '__screenshots__', getTestName(test), test.browserId);
  },
};
