const path = require('path');

/**
 * @type {Partial<jest.InitialOptions>}
 */
module.exports = {
  preset: 'ts-jest',
  testEnvironment: 'jsdom',

  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/src/**/*.test.{ts,tsx}'],
  modulePathIgnorePatterns: ['<rootDir>/dist'],
  setupFilesAfterEnv: ['<rootDir>/.config/jest/jest.setup.js'],

  moduleNameMapper: {
    '\\.css$': '<rootDir>/.config/jest/__mocks__/noop.js',
    '^react$': '<rootDir>/node_modules/react/cjs/react.development.js',
    '^react-dom$': '<rootDir>/node_modules/react-dom',
  },

  globals: {
    'ts-jest': {
      tsconfig: '<rootDir>/tsconfig.test.json',
    },
  },

  reporters: [
    'default',
    [
      'jest-html-reporter',
      {
        outputPath: '__reports/report-unit/index.html',
        pageTitle: 'Report',
        includeFailureMsg: true,
        includeConsoleLog: true,
      },
    ],
  ],

  haste: {
    forceNodeFilesystemAPI: true,
  },
};
