const css_regex = '/\\.css$/';

const findCssRule = (rules) => {
  return rules.find((rule) => rule && rule.test && rule.test.toString() === css_regex);
};

const omitCssRule = (rules) => {
  return rules.filter((rule) => rule && rule.test && rule.test.toString() !== css_regex);
};

const modifyCssLoaders = (rule) => {
  return rule.use.map((item) => {
    if (item && item.loader && item.loader.match(/[\/\\]css-loader/g)) {
      return {
        ...item,
        options: {
          modules: {
            localIdentName: '[folder]__[local]__[hash:base64:5]',
          },
        },
      };
    }

    return item;
  });
};

module.exports = {
  webpackFinal(config) {
    const cssRule = findCssRule(config.module.rules);
    const otherRules = omitCssRule(config.module.rules);

    return {
      ...config,
      module: {
        ...config.module,
        rules: [
          ...otherRules,
          {
            ...cssRule,
            exclude: /\.module\.css$/,
          },
          {
            ...cssRule,
            test: /\.module\.css$/,
            use: modifyCssLoaders(cssRule),
          },
        ],
      },
    };
  },
};
